/** @type {import('tailwindcss').Config} */
module.exports = {
  content: [
    './pages/**/*.{js,ts,jsx,tsx,mdx}',
    './components/**/*.{js,ts,jsx,tsx,mdx}',
    './app/**/*.{js,ts,jsx,tsx,mdx}',
  ],
  theme: {
    extend: {
      colors: {
        'primaryGreen': '#55a654', 
        'primaryGreen20': '#55a65423',
        'darkGrey':  '#555',
        'white76':  '#ffffff76',
      },
      backgroundImage: {
        'client': "url('/client.png')",
        'helper': "url('/helper.png')",
        // 'carpentry': "url('/carpentry.jpg')",
        // 'errands': "url('/errands.jpg')",
        "404-layout": "url('/404-img.jpg')",
        'footer-texture': "url('/img/footer-texture.png')",
        'purple-layout': "url('/bg-layout.svg')",
        'blue-layout': "url('/bg-layout-2.svg')",
        'olive-layout': "url('/bg-layout-3.svg')",
        'client-hero': "url('/client-hero-layout.svg')",
      },
      fontFamily : {
        poppins: ['var(--font-poppins)'],
        fraunces: ['var(--font-fraunces)'],
        Itim: ["var(--font-itim)"],
      },
      keyframes: {
        slideBottom: {
          '0%': { transform: 'translateY(-8px)' },
          '100%': { transform: 'translateY(0px)' },
        },
        slideTop: {
          '0%': { transform: 'translateY(0px)' },
          '100%': { transform: 'translateY(-30px)' },
        },
        wiggle: {
          '0%, 100%': { transform: 'rotate(-3deg)' },
          '50%': { transform: 'rotate(3deg)' },
        }, 
        slideIn: {
          '0%': { opacity: '0' },
          '100%': { opacity: '1' },
          // '100%': { opacity: '0' },
        }
      },
      animation: {
        'spin-slow': 'spin 3s linear infinite',
        'slide-down': 'slideBottom .3s  cubic-bezier(0.25, 0.46, 0.45, 0.94) both',
        'slide-up': 'slideTop .3s  cubic-bezier(0.25, 0.46, 0.45, 0.94) both',
        'slide-in': 'slideIn 5s ease-in-out infinite'
      }
    },
  },
  plugins: [
    require('tailwind-scrollbar-hide')
  ],
}
