import { request, gql } from 'graphql-request';
const graphqlAPI = process.env.NEXT_PUBLIC_GRAPHCMS_ENDPOINT;

export const getPosts = async () => {
  const queryPosts = gql`
   
        {
          posts (orderBy: datePublished_DESC, first: 1000) {
            author {
              bio
              name
              id
              photo {
                url
              }
            }
            datePublished
            slug
            title
            excerpt
            featuredImage {
              url
            }
            category {
              name
              slug
            }
          }
        }
            
          
          
      
  `;

  const result = await request(graphqlAPI, queryPosts);

  return result.posts;
};


export const getPostDetails = async (slug) => {
  const queryPostDetails = gql`
query Post($slug: String!) {
  post(where: { slug: $slug }) {
    id
    title
    slug
    datePublished
    excerpt
    featuredPost
    author {
      id
      name
      bio
      photo {
        url
      }
    }
    content {
      html
    }
    featuredImage {
      url
    }
    category {
      name
      slug
    }
  }
}
`;

const result = await request(graphqlAPI, queryPostDetails, {slug})
// console.log(result);
return result.post
}


export const getSimilarPosts = async (categories, slug) => {

  const querySimilarPosts = gql`
    query GetPostDetails($slug: String!, $categories: [String!]) {
      posts(
        where: {slug_not: $slug, AND: {category_some: {slug_in: $categories}}}
        last: 3
      ) {
        author{
        name
        }
        title
        featuredImage {
          url
        }
        datePublished
        slug
      }
    }
  `;
  const result = await request(graphqlAPI, querySimilarPosts, { slug, categories });
// console.log(result.posts);
  return result.posts;
};




export const getCategories = async () => {
 const queryCategories = gql`
 query GetCategories {
  categories {
    name
    slug
  }
}
 `;

 const result = await request(graphqlAPI, queryCategories);
// console.log(result);
  return result.categories;
}


export const getCategoryPost = async (slug) => {
  const queryCatrgoryPost = gql`
  query GetCategoryPost($slug: String!) {
    posts(orderBy: datePublished_DESC, where: {category_some: {slug: $slug}}) {
      author {
        bio
        name
        id
        photo {
          url
        }
      }
      datePublished
      slug
      title
      excerpt
      featuredImage {
        url
      }
      category {
        name
        slug
      }
    }
  }
`;

const result = await request(graphqlAPI, queryCatrgoryPost, { slug });

return result.posts;

}