import { GraphQLClient, gql } from "graphql-request";

const graphCms = new GraphQLClient(
     "https://api-ca-central-1.hygraph.com/v2/cljdyzqaf01fb01uj0n9n49w9/master"
);

const QUERY = gql`
{
    posts (orderBy: datePublished_DESC, first: 1000) {
        datePublished
         excerpt
         featuredPost
         id
         slug
         title
         content {
           html
         }
         featuredImage {
           url
         }
         author {
           name
           photo {
             url
           }
         } 
       }

       authors {
         id
         name
         bio
         photo {
           url
         }
       }
}
`;

const QUERYPOST = gql`
query Post($slug: String!) {
  post(where: { slug: $slug }) {
    id
    title
    slug
    datePublished
    excerpt
    featuredPost
    author {
      id
      name
      bio
      photo {
        url
      }
    }
    content {
      html
    }
    featuredImage {
      url
    }
  }
}
`;

export const getPosts = async () => {
// QUERY
const result = await graphCms.request(QUERY);
// console.log(result.posts);
return result.posts
}


export const getPostDetails = async (slug) => {
    // QUERYPOST
    const result = await graphCms.request(QUERYPOST, {slug});
    return result.post
} 