import Head from "next/head";
import Script from "next/script";
// import Image from "next/image";
import { Fraunces, Poppins } from "next/font/google";
import HomePage from '../components/HomePage';
import WaitlistPopup from "@/components/WaitlistPopup";
import { getPosts } from "../services/prod";
import { NextSeo } from 'next-seo';
import SEO from '@/next-seo-config'

const fraunces = Fraunces({ subsets: ["latin"], weight:["500", "600"] });
const poppins = Poppins({ subsets: ["latin"], weight:["300","400","500"] });


export async function getStaticProps() {
  const posts = (await getPosts()) || [];

  return {
    props: {
      posts
    },
    revalidate: 30
     // will be passed to the page component as props
  };
}


export default function Home({ posts }) {
  // console.log(posts?.category);

  return (
    <main
      className={` ${poppins.className}`}>

<NextSeo {...SEO} />
        {/* <!-- Google tag (gtag.js) --> */}
      <Script
        async
        src="https://www.googletagmanager.com/gtag/js?id=G-VT45BTTH9F"
      />

      <Script id="google-analytics">
        {`
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());

        gtag('config', 'G-VT45BTTH9F');
      `}
      </Script>

      
      {/* <NextSeo
      title="HouseHelpApp - Get on-demand services for your everyday needs."
      description="An online marketplace to outsource tasks to skilled and vetted freelancers for everyday needs. Become a helper today, complete tasks and earn money."
      openGraph={{
        type: 'website',
        locale: 'en_IE',
        url: 'https://www.url.ie/',
        siteName: 'SiteName',
      }}
      twitter={{
        handle: '@handle',
        site: '@site',
        cardType: 'summary_large_image',
      }}
    /> */}
 {/* {posts.map((post, index) => (
         console.log(post?.node)
          ))} */}

<WaitlistPopup />
       <HomePage posts={posts}  />
    </main>
  );
}
