// import BlogPage from "../components/BlogPage";
// import { getPosts } from '../services';
// import { NextSeo } from "next-seo";


// export async function getStaticProps() {
//     const posts = await getPosts()
  
//     return {
//       props: {
//         posts,
//       },
//       // revalidate: 30
//        // will be passed to the page component as props
//     }
//   }

// export default function Blog ({posts}) {


//     return (
//       <div>
//          <NextSeo title='Blog - Home of Tips and DIYs to make your life easier.' description='Articles to learn and improve your everyday life.' />
//         <BlogPage posts={posts} /> 
//       </div>
//     )
// }


import BlogPage from "../components/BlogPage";
import { getPosts } from '../services';
import { NextSeo } from "next-seo";

export async function getStaticProps() {
  const posts = await getPosts();
  
  return {
    props: { posts },
    // revalidate: 30
  };
}

export default function Blog({ posts }) {
  return (
    <>
      <NextSeo 
        title='Blog - Home of Tips and DIYs to make your life easier' 
        description='Articles to learn and improve your everyday life'
        openGraph={{
          title: 'HouseHelpApp Blog',
          description: 'Discover tips and DIY solutions for your everyday needs',
        }}
      />
      <BlogPage posts={posts} />
    </>
  );
}