
import { useEffect } from 'react';
import "../styles/globals.css";
import Head from "next/head";
import ClientWrapper from "@/components/ClientWrapper";

export default function App({ Component, pageProps }) {
  useEffect(() => {
    if ('serviceWorker' in navigator) {
      window.addEventListener('load', () => {
        navigator.serviceWorker.register('/service-worker.js')
          .then(registration => {
            console.log('SW registered: ', registration);
          })
          .catch(registrationError => {
            console.log('SW registration failed: ', registrationError);
          });
      });
    }
  }, []);

  return (
    <>
    <Head>
        <meta name="google-site-verification" content="7aUpDk9zEpo0FTlHbIrte15KDjaJV3Ns0T96ubiZssU" />
      </Head>
    <ClientWrapper>
        <Component {...pageProps} />  
    </ClientWrapper>
    </>
  );
}
