// /** @type {import('next').NextConfig} */
// import withVideos from 'next-videos';
// const nextConfig = {
//   reactStrictMode: true,
//   trailingSlash: true,
//   // output: 'export',
//   images: {
//     unoptimized: true
// },
// experimental: {
//   workerThreads: false,
//   cpus: 1
// },
// };

// export default withVideos(nextConfig);
// // export default nextConfig;


/** @type {import('next').NextConfig} */
import withVideos from 'next-videos';

const nextConfig = {
  reactStrictMode: true,
  trailingSlash: true,
  // output: 'export', // Static export for cPanel
  // images: {
  //   unoptimized: true // Required for static export
  // },
  experimental: {
    workerThreads: false,
    cpus: 1
  },
  // Manual PWA configuration for static export
  async headers() {
    return [
      {
        source: '/service-worker.js',
        headers: [
          {
            key: 'Cache-Control',
            value: 'public, max-age=0, must-revalidate',
          },
        ],
      },
    ]
  }
};

export default withVideos(nextConfig);