import React from "react";
import Image from "next/image";
import loaderImg from "@/public/hha-loader.svg";
import LoadingSkeleton from "./components/LoadingSkeleton";

const texts = [
  "Keep your home in top shape by regularly cleaning gutters to prevent water damage and checking for leaks in faucets and pipes.",
  "Give your space a fresh look by repurposing old furniture with a coat of vibrant paint or creating unique wall art from recycled materials.",
  "Tighten loose cabinet handles and knobs with a screwdriver to add stability and avoid potential accidents.",
  "Outsource your grocery shopping with HouseHelpApp – let a reliable errand service handle the hassle while you focus on more important things.",
  "Need a package delivered ASAP? Choose from a variety of reliable delivery services on HouseHelpApp for swift and secure shipping.",
  "Transform your living space with a fresh coat of paint – find skilled painters on HouseHelpApp for a professional touch.",
  "Keep your garden flourishing by watering plants early in the morning and mulching to retain soil moisture.",
  "Mix vinegar and baking soda for an eco-friendly and cost-effective cleaner that tackles stubborn stains and odors.",
  "Leaky faucet driving you crazy? Connect with skilled plumbers on HouseHelpApp to fix the issue before it becomes a bigger problem..",
  "Regularly check electrical outlets and replace any damaged cords to prevent potential fire hazards.",
  "Skip the frustration – hire professionals on HouseHelpApp for quick and efficient furniture assembly without the headache.",
  "Juggling a busy schedule? Find trustworthy personal assistants on HouseHelpApp to manage your tasks and appointments.",
  "Seal gaps around windows and doors with weather stripping to improve insulation and reduce energy bills.",
  "Troubleshooting tech issues? Discover skilled IT professionals on HouseHelpApp for quick and effective solutions.",
  "Extend the life of your appliances by cleaning filters, checking for leaks, and scheduling routine maintenance with qualified technicians on HouseHelp App.",
  "Maximize space with DIY storage solutions – repurpose old crates or create hanging organizers to keep clutter at bay",
  "Need someone to walk your furry friend? Explore pet care services on HouseHelpApp for reliable and caring pet sitters.",
  "Enhance your home's security by installing motion sensor lights and reinforcing doors and windows with sturdy locks.",
  "Tired of mowing the lawn? Find skilled landscapers on HouseHelpApp to keep your yard pristine without breaking a sweat."
];

const Loading = () => {

  return (
    <div className={`w-full top-0 fixed inset-0 bg-primaryGreen20 flex flex-col justify-center items-center overflow-hidden `}>    
      <Image
        src={loaderImg}
        className="bouncing-element "
        alt="loadimg image"
        priority
      />
      <LoadingSkeleton texts={texts} />
    </div>
  );
};

export default Loading;


// const bgColor = [
//   'loader-bg1',
//   'loader-bg2',
//   'loader-bg3'
// ]

  // const randomBgColor = bgColor[Math.floor(Math.random() * bgColor?.length)];