"use client"
import React from 'react'
import Image from 'next/image'
import Link from 'next/link'
// import QR from '@/public/client-qr.png'
// import { motion, useScroll } from "framer-motion";
import * as motion from "framer-motion/client"

const variants = {
  hidden: { opacity: 0, x: -10, y: 0 },
  enter: { opacity: 1, x: 0, y: 0,  transition: {
    type: "spring",
    bounce: 0.4,
    duration: 1
  } },
}

const variantsImg = {
  hidden: {opacity: 0, x:20, y:0},
  enter: { opacity: 1, x: 0, y: 0,  transition: {
    type: "spring",
    bounce: 0.2,
    duration: 1,
    delay: .2
  } },
}

// const clientSurveyData = [
//   {
//     title: 'Client Survey',
//     description: 'Your feedback helps us make HouseHelpApp better for you! Scan the QR code or click the survey button to share your thoughts and help shape our future improvements 😀 ',
//     link: 'https://docs.google.com/forms/d/e/1FAIpQLScjjjbJZBrCNJDjlvhiBATeAFm7AtoekyV1LE7eU_NcyP39lA/viewform?usp=sf_link'
//   }
// ]
// const helperSurveyData = [
//   {
//     title: 'Helper Survey',
//     description: "As a potential Helper, your opinion matters to us! Share your thoughts to help us improve our service. Just scan the QR code or click the survey button 👍🏽",
//     link: 'https://forms.gle/D2UE7DaruPgYKwS17'
//   }
// ]

const Survey = ({data}) => {
  // bg-[#C0EBA6]
  return (
    <div className='w-full  flex justify-center px-4 pb-24 bg-[#fdfdff] '>
    <motion.div  initial="hidden"
      whileInView="enter"
      viewport={{ once: true, amount: 0.6 }} className='w-full max-w-[960px] bg-[#193E43]  flex sm:flex-row items-center justify-center flex-col gap-8 rounded-lg shadow-sm  py-[48px] md:py-[72px] '>

{data?.map((item, index) => (
  <>
  <motion.div key={index} variants={variants} className='flex flex-col items-center md:items-start'>
  <h3 className='text-[24px] md:text-[30px] prodigySans600 text-[#fff]'>{item.title}</h3>
        <p  className='text-[14px] md:text-[16px] mt-[14px] md:mt-[18px] w-full max-w-[384px] md:max-w-[390px] text-[#fff] px-4 sm:px-0'> {item.description}</p>
        <button className='bg-[#55a654] hover:translate-y-1 transition-all ease-linear shadow-sm p-2 text-[#fff] font-[500] text-[.8em] md:text-[1em] mt-[2em] rounded-[4px]' ><Link href={item.link} aria-label="survey link" target="_blank" 
        rel="noopener noreferrer" >Take survey</Link> </button>
</motion.div>

<motion.div variants={variantsImg} key={item.title}>
<Image
              src={item.img}
              alt="qr-code client"
              className="w-[10em] h-[10em] md:w-[12em] md:h-[12em]"
            />
</motion.div>

  </>

))}

{/* {
  data.map((item2) => (
    <motion.div variants={variantsImg}>
<Image
              src={item2.img}
              alt="qr-code client"
              className="w-[10em] h-[10em] md:w-[12em] md:h-[12em]"
            />
</motion.div>
  ))
} */}

{/* <motion.div variants={variantsImg}>
<Image
              src={QR}
              alt="qr-code client"
              className="w-[10em] h-[10em] md:w-[12em] md:h-[12em]"
            />
</motion.div> */}
      
                   


        </motion.div>
       
</div>
  )
}

export default Survey
// text-[.8em] md:text-[1em]
// bg-[#d3efc3]