import React, { useState, useRef, useEffect } from 'react'
import Link from 'next/link';
import Image from 'next/image';
import client from '@/public/client.png';
// import signup from '@/public/video/client-signup.mp4'
import signup from '@/public/video/post-task.mp4'
// import signup from '@/public/signup-client.png'
// import { clientData } from '@/constants/data';

const StepsCard = ({data, cat}) => {
    const [loadedVideos, setLoadedVideos] = useState({});

    const videoRefs = useRef({});

     // Initialize video refs for each card
  const initVideoRef = (index) => {
    if (!videoRefs.current[index]) {
      videoRefs.current[index] = React.createRef();
    }
  };

   // Preload videos when component mounts
   useEffect(() => {
    data.forEach((item, index) => {
      const video = videoRefs.current[index]?.current;
      
      if (video) {
        // Set video to load metadata first
        video.preload = 'metadata';
        
        // Add event listeners for loading states
        const handleLoadedData = () => {
          setLoadedVideos(prev => ({
            ...prev,
            [index]: true
          }));
        };

        const handleLoadStart = () => {
          // Attempt to load the full video after metadata is loaded
          video.preload = 'auto';
        };

        video.addEventListener('loadeddata', handleLoadedData);
        video.addEventListener('loadstart', handleLoadStart);

        // Load the video
        video.load();

        // Cleanup
        return () => {
          video.removeEventListener('loadeddata', handleLoadedData);
          video.removeEventListener('loadstart', handleLoadStart);
        };
      }
    });
  }, [data]);


 // Handle mouse enter
 const handleMouseEnter = (index) => {
    const video = videoRefs.current[index]?.current;
    if (video && loadedVideos[index]) {
      video.play().catch(error => {
        console.log('Video playback failed:', error);
      });
    }
  };

  // Handle mouse leave
  const handleMouseLeave = (index) => {
    const video = videoRefs.current[index]?.current;
    if (video && loadedVideos[index]) {
      video.pause();
      video.currentTime = 0;
    }
  };




//   // Handle mouse enter
//   const handleMouseEnter = (index) => {
//     const video = videoRefs.current[index].current;
//     if (video) {
//       video.play();
//     }
//   };

//     // Handle mouse leave
//     const handleMouseLeave = (index) => {
//         const video = videoRefs.current[index].current;
//         if (video) {
//           video.pause();
//           video.currentTime = 0;
//         }
//       };
    console.log(cat);
  return (
     <div className='w-full flexCenter'>
            <div className='flex flex-wrap  mx-[1rem] max-w-[1200px] mb-24 gap-12 items-center justify-center hover:cursor-pointer'>
           
                {data.map((item, index) => {
                    initVideoRef(index);
                    return(
                        <div
                        className="max-w-[350px] xl:max-w-[544px] max-h-[390px] xl:max-h-[192px] bg-[#fbfbfb] flex flex-col xl:flex-row items-center rounded-md outline outline-[#dfdfdf] outline-[.75px] shadow-md text-black overflow-hidden"
                        key={index}
                        onMouseEnter={() => handleMouseEnter(index)}
                        onMouseLeave={() => handleMouseLeave(index)}
                        
                        >
                           
                           <div className={`w-full xl:min-w-[206px] h-[192px] xl:rounded-l-md rounded-t-sm flexCenter overflow-hidden object-cover hover:scale-[1.035] transition-all ease-linear duration-[1.75] ${cat === 'client' ? 'bg-[#edf2ff]' : 'bg-[#e3f3f4]'}  relative`}>
                          
                           {!loadedVideos[index] && (
                  <div className="absolute inset-0 flex items-center justify-center">
                    <div className="w-8 h-8 border-4 border-primary border-t-transparent rounded-full animate-spin" />
                  </div>
                )}
                          
                          
                           <video
                              
                                    ref={videoRefs.current[index]}
                                    className={`w-[10rem] absolute top-2 transition-opacity duration-300 ${
                                        loadedVideos[index] ? 'opacity-100' : 'opacity-0'
                                      }`}
                                    // className='w-[10rem] absolute top-2'
                                    src={item.video}
                                    alt="blog-post image"
                                    width={100}
                                    height={100}
                                   //  autoPlay
                                   loop
                                   muted
                                   playsInline
                       
                                />
                       
                           </div>
                       
                               
                                <div className="py-[1rem] px-[.5rem] w-full ">
                                
                                    <h1 className="text-[14px] xl:text-[15px] prodigySans600 text-[#1c1c1c] mt-2 hover:text-primaryGreen transition-all ease-linear">
                                        {item.header}
                                    </h1>
                                    <p className={`text-[12px] font-normal mt-[4px]`}>{item.description}</p>
                                </div>
                       
                        </div>
                    );

})}
                   
          
            </div>
        </div>
  )
}

export default StepsCard