// 'use client'
// import React, { useState, useEffect } from 'react'
// import { getSimilarPosts} from '../services/prod';
// import BlogCardComponent from './BlogCardComponent';


// const SimilarCategoryPosts = ({ categories, slug }) => {
//   const [relatedPosts, setRelatedPosts] = useState([]);
  

//   useEffect(() => {
//     // console.log(slug, categories);
//     if(slug) {
//       getSimilarPosts(categories, slug).then((result) => {
//         console.log(result);
//        return setRelatedPosts(result);
//       })
//     };

//   }, [slug, categories])
  

  
//   // console.log(relatedPosts.length);
//   // console.log("similar posts are:", posts)
//   return (
//     <div className='w-full  flexCenter flex-col'>
//       <di className={`${relatedPosts?.length === 0 ? 'hidden' : 'inline-block'} w-full max-w-[1248px]  bg-[#ebf4e896] px-4 pt-[24px] pb-[36px] rounded-xl`}>
//       <p className='mb-6 prodigySans500 text-[16px] md:text-[20px] text-center pl-4 '>Related articles </p>
//         <div className='w-full max-w-[1200px] flex flex-col items-center justify-center md:justify-between '>
//         <BlogCardComponent posts={relatedPosts} pageDisplay={'BlogDetails'}  />
//         </div>
//       </di>
       
//     </div>
//   )
// }



// export default SimilarCategoryPosts



'use client'
import React, { useState, useEffect } from 'react'
import { getSimilarPosts } from '../services/prod';
import BlogCardComponent from './BlogCardComponent';
import { motion } from 'framer-motion';

const SimilarCategoryPosts = ({ categories, slug }) => {
  const [relatedPosts, setRelatedPosts] = useState([]);
  const [isLoading, setIsLoading] = useState(true);

  useEffect(() => {
    if (slug) {
      setIsLoading(true);
      getSimilarPosts(categories, slug)
        .then((result) => {
          setRelatedPosts(result);
        })
        .finally(() => setIsLoading(false));
    }
  }, [slug, categories]);

  if (!relatedPosts?.length) return null;

  return (
    <motion.section
      initial={{ opacity: 0 }}
      whileInView={{ opacity: 1 }}
      viewport={{ once: true, margin: "0px 0px -100px 0px" }}
      className="w-full mt-16 bg-primaryGreen10 px-4 py-12 rounded-xl"
    >
      <div className="max-w-7xl mx-auto">
        <h2 className="text-2xl md:text-3xl font-bold text-center mb-8 text-gray-800">
          You might also like
        </h2>
        
        {isLoading ? (
          <div className="flex justify-center py-12">
            <div className="animate-spin rounded-full h-8 w-8 border-b-2 border-primaryGreen" />
          </div>
        ) : (
          <BlogCardComponent 
            posts={relatedPosts} 
            pageDisplay={'BlogDetails'} 
          />
        )}
      </div>
    </motion.section>
  );
};

export default SimilarCategoryPosts;