'use client'
import React, { useRef, useEffect, useState } from 'react';
import { useGSAP } from '@gsap/react';
import gsap from 'gsap';
import ScrollTrigger from "gsap/dist/ScrollTrigger";
import { useRouter } from 'next/router';


// Register GSAP plugins
gsap.registerPlugin(useGSAP);
gsap.registerPlugin(ScrollTrigger);

const ScrubComponent = ({data, ref}) => {
  const [renderKey, setRenderKey] = useState(0);
  const router = useRouter();

  const containerRef = useRef(null);

  useEffect(() => {
    // Force re-render when navigating to this page
    const handleRouteChange = () => {
      setRenderKey((prevKey) => prevKey + 1);
    };

    router.events.on('routeChangeComplete', handleRouteChange);
    
    return () => {
      router.events.off('routeChangeComplete', handleRouteChange);
    };
  }, [router]);

  
  useGSAP(() => {
    if (typeof window !== 'undefined') {
    const ctx = gsap.context(() => {
   
      gsap.set(".photo:not(:first-child)", { opacity: 0, scale: 0.5 });
      
      const animation = gsap.to(".photo:not(:first-child)", {
        opacity: 1,
        scale: 1,
        duration: 0.6,
        stagger: 1
      });
      
      ScrollTrigger.create({
        trigger: ".gallery",
        start: "top 240px",
        end: "bottom 510px",
        pin: ".leftblock",
        animation: animation,
        scrub: true,
        markers: false,
      });
    }, containerRef);
   
    
    return () => ctx.revert();
  }
  }, [data, renderKey, router.asPath]);

  return (
    <div ref={containerRef} className="w-full h-full">
      <div className="w-full max-w-6xl mx-auto flex flex-col md:flex-row items-stretch gallery mb-[280px]">
        {/* Left Block - Photos */}
        <div className="w-full md:w-1/2 leftblock h-[410px] relative overflow-hidden">
          {data?.map((item) => (
            <div
              key={item.id}
              className={`photo absolute top-0 left-0 w-full max-w-[468px] h-[420px] rounded ${item.img} bg-cover`}
            />
          ))}
        </div>

        {/* Right Block - Content */}
        <div className="w-full md:w-1/2">
          {data?.map((item) => (
            <div key={item.id} className="flex flex-col justify-center max-h-[400px] pt-[120px] p-6">
              <div className="border border-gray-200 rounded-lg p-6 shadow-md">
                <div className="flex items-start gap-4">
                  <div className="flex-shrink-0 w-12 h-12 bg-[#55a654] text-white rounded-lg flex items-center justify-center text-xl font-bold">
                    {item.id}
                  </div>
                  <div className="flex-1">
                    <h5 className="text-xl font-bold mb-2">{item.header}</h5>
                    <p className="text-gray-600">{item.description}</p>
                  </div>
                </div>
              </div>
            </div>
          ))}
        </div>
      </div>
    </div>
  );
};

export default ScrubComponent;
