import React from 'react'

const Privacy = () => {
  return (
    <div className='w-full flex justify-center items-center px-4 pt-[80px] sm:pt-[140px] pb-40'>
    <div className='w-full max-w-[1000px] font-poppins '> 
    <h2 className='text-[20px] font-bold  text-blue-600 mb-8'>HouseHelpApp Data Policy</h2>
    <div className='flex flex-col gap-y-2'>
        <h4 className='text-[18px] font-bold  text-blue-600'>Introduction </h4>
        <p>HouseHelpApp is committed to maintaining the highest standards of data privacy and protection. Our Data Policy outlines the principles and practices we follow in handling user data, ensuring transparency, security, and responsible usage. </p>
    </div>
      

<div className='flex flex-col gap-y-2 mt-8'>
<h4 className='text-[18px] font-bold  text-blue-600'>Data Collection </h4>
        <p>HouseHelpApp collects the following user data: </p>
        <ul className='flex flex-col gap-y-2 list-disc pl-6'>
            <li><span className='font-semibold'>Full Name:</span>  To personalize user experience and for identification purposes. </li>
            <li><span className='font-semibold'>Address:</span>  Essential for providing location-specific services. </li>
            <li><span className='font-semibold'>Occupation:</span> Helps in understanding the context of service requirements. </li>
            <li><span className='font-semibold'>Phone Number:</span> For communication and service coordination. </li>
            <li><span className='font-semibold'>Email:</span> Used for account setup, notifications, and promotional purposes. </li>
            <li><span className='font-semibold'>User Task Need (Task Description):</span> To tailor our services to individual preferences and improve AI model accuracy. </li>
            <li><span className='font-semibold'>User Image:</span> For enhancing user profile authenticity and personalization. </li>
        </ul>
</div>
      

<div className='flex flex-col gap-y-2 mt-8'>
<h4 className='text-[18px] font-bold  text-blue-600'>Use of Data </h4>
        <h5 className='text-[16px] font-semibold  text-blue-600'>AI Model Training </h5>
        <ul className='flex flex-col gap-y-2 list-disc pl-6'>
            <li><span className='font-semibold'>Task Preferences:</span> User task needs are utilized to train our AI models, enabling us to better understand and predict individual preferences. </li>
            <li><span className='font-semibold'>Pricing Predictions:</span> This data aids in developing more accurate pricing algorithms, ensuring fair and competitive rates for our services. </li>
        </ul>

        <h5 className='text-[16px] font-semibold  text-blue-600'>Service Improvement  </h5>
        <ul className='flex flex-col gap-y-2 list-disc pl-6'>
            <li><span className='font-semibold'>Personalization:</span> We leverage user data to customize our services, ensuring a more relevant and efficient user experience. </li>
            <li><span className='font-semibold'>Communication:</span> Contact details are used for efficient service coordination and to keep users informed about our offerings and updates.  </li>
        </ul>
        <h5 className='text-[16px] font-semibold  text-blue-600'>Security and Compliance </h5>
        <ul className='flex flex-col gap-y-2 list-disc pl-6'>
            <li><span className='font-semibold'>Data Protection:</span> We employ robust security measures to protect user data against unauthorized access, alteration, and misuse.  </li>
            <li><span className='font-semibold'>Legal Compliance:</span> All data handling practices adhere to applicable data protection laws and regulations.  </li>
        </ul>
</div>
   
<div className='flex flex-col gap-y-2 mt-8'>
<h4 className='text-[18px] font-bold  text-blue-600'>Data Sharing and Disclosure </h4>
        <p>HouseHelpApp does not sell or rent user data to third parties. Data may be shared with trusted partners solely for the purpose of improving service delivery and operational efficiency. Any data sharing complies with our stringent privacy standards and legal obligations. </p>
</div>
     

        <div className='flex flex-col gap-y-2 mt-8'>
        <h4 className='text-[18px] font-bold  text-blue-600'>User Rights and Control </h4>
<p>Users have the right to access, modify, or delete their personal data. HouseHelpApp provides easy-to-use tools for users to exercise these rights. We also offer options to opt-out of certain data uses, such as marketing communications. </p>
        </div>


<div className='flex flex-col gap-y-2 mt-8'>
<h4 className='text-[18px] font-bold  text-blue-600'>Data Retention </h4>
<p>User data is retained only as long as necessary to provide our services and comply with legal obligations. We regularly review and anonymize or delete data that is no longer needed. </p>
</div>


<div className='flex flex-col gap-y-2 mt-8'>
<h4 className='text-[18px] font-bold  text-blue-600'> Policy Updates </h4>
<p>This Data Policy may be updated periodically to reflect changes in our practices or legal requirements. Users will be notified of significant changes through our app or via email. </p>
</div>

<div className='flex flex-col gap-y-2 mt-8'>
<h4 className='text-[18px] font-bold  text-blue-600'>Contact Information </h4>
<p>For questions or concerns regarding this Data Policy or data handling practices, users can contact our Data Protection Officer at support@househelpapp.com. 

This policy is crafted to ensure that HouseHelpApp&apos;s data handling practices are transparent, secure, and aligned with our commitment to user privacy and trust. </p>
</div>










    </div>
    </div>
  )
}

export default Privacy