'use client'
import React, { useState } from 'react';
import Image from 'next/image';
import Link from 'next/link';
import LogoBig from '@/public/logo-only.svg';
import { navLinks } from '@/constants';
import { MdMenu, MdClose, MdArrowDropDown } from 'react-icons/md';

const Navbar = () => {
    const [toggle, setToggle] = useState(false);
    const [openSubNav, setOpenSubNav] = useState(null);

    const handleSubNavToggle = (index) => {
        setOpenSubNav(openSubNav === index ? null : index); 
    };

    const closeMobileMenu = () => setToggle(false);

    const MenuButton = ({ isOpen }) => (
        <div onClick={() => setToggle(!toggle)} className="w-[36px] h-[36px] bg-primaryGreen20 text-darkGrey hover:text-primaryGreen flexCenter rounded-lg cursor-pointer">
            {isOpen ? <MdClose className='text-[24px]' /> : <MdMenu className='text-[24px]' />}
        </div>
    );

    const RenderSubNav = ({ subnav, index }) => (
        <ul className="absolute top-full left-0 mt-4 bg-white w-[140px] h-[84px] p-2 rounded-xl shadow-lg">
            {subnav.map((subItem, subIndex) => (
                    <Link key={subItem.id} href={`/${subItem.id}`} onClick={() => setOpenSubNav(null)}>
                <li key={subItem.id} className="text-darkGrey hover:text-white hover:bg-primaryGreen rounded-xl px-3 py-1">
                        {subItem.title}
                </li>
                    </Link>
            ))}
        </ul>
    );

    return (
        <nav className="w-full flexCenter h-[72px] sm:h-[80px] fixed px-2 z-[1000] mt-2">
            <div className="w-full max-container-1248 rounded-full px-8 sm:px-16 bg-white76 backdrop-blur-xl flexBetween h-full  shadow">
                <Link href={'/'}>
                    <Image src={LogoBig} alt="logo" width={48} height={48} className="max-w-[36px] sm:max-w-[42px]" />
                </Link>

                {/* Desktop nav links */}
                <ul className="sm:flex hidden font-poppins font-medium text-1 rounded-full bg-primaryGreen20 h-[48px] items-center px-4 gap-2 cursor-pointer">
                    {navLinks.map((nav, index) => (
                        <li key={nav.id} className="text-darkGrey prodigySans500  hover:text-primaryGreen transform duration-75 rounded-none p-1 relative">
                            {nav.subnav ? (
                                <div className="flexCenter cursor-pointer" onClick={() => handleSubNavToggle(index)}>
                                    {nav.title}
                                    <MdArrowDropDown className="ml-1" />
                                </div>
                            ) : (
                                <Link href={`/${nav.id}`}>{nav.title}</Link>
                            )}
                            {nav.subnav && openSubNav === index && <RenderSubNav subnav={nav.subnav} index={index} />}
                        </li>
                    ))}
                </ul>

                {/* Mobile nav toggle */}
                <div className="sm:hidden flex">
                    <MenuButton isOpen={toggle} />
                    <div className={`${!toggle ? "hidden" : "flex"} w-full h-fit absolute top-0 right-1 mt-[4.8rem] py-2 max-w-[198px] bg-white text-darkGrey backdrop-blur-lg  shadow-md rounded-xl`}>
                        <ul className="w-full flex flex-col justify-center prodigySans500">
                            {navLinks.map((nav, index) => (
                                <li key={nav.id} className="hover:text-white px-2 py-1 relative">
                                    {nav.subnav ? (
                                        <div className="flexStart cursor-pointer rounded-lg p-1 hover:bg-primaryGreen hover:text-white text-darkGrey" onClick={() => setOpenSubNav(openSubNav === index ? null : index)}>
                                            {nav.title}
                                            <MdArrowDropDown className="ml-1" />
                                        </div>
                                    ) : (
                                        <Link href={`/${nav.id}`} onClick={closeMobileMenu} className="hover:bg-primaryGreen flex text-darkgrey rounded-lg hover:text-white p-1 ">
                                            {nav.title}
                                        </Link>
                                    )}
                                    {nav.subnav && openSubNav === index && (
                                        <ul className="mt-1 bg-primaryGreen20  rounded-lg px-2 py-1  ">
                                            {nav.subnav.map((subItem, subIndex) => (
                                                    <Link key={subItem.id} href={`/${subItem.id}`} onClick={() => {
                                                        setOpenSubNav(null);
                                                        closeMobileMenu();
                                                    }}>
                                                <li key={subItem.id} className="text-darkGrey  hover:text-white hover:bg-primaryGreen rounded-lg px-2 py-1">
                                                        {subItem.title}
                                                </li>
                                                    </Link>
                                            ))}
                                        </ul>
                                    )}
                                </li>
                            ))}
                        </ul>
                    </div>
                </div>
            </div>
        </nav>
    );
};

export default Navbar;
