'use client'
import React, {useState, useEffect} from "react";
import HowItworksComponent from "./HowItworksComponent";
import * as motion from "framer-motion/client"

const HowItWorksContainer = ({data}) => {

  const variants = {
    hidden: {opacity: 0, x:0, y:20},
    enter: { opacity: 1, x: 0, y: 0,  transition: {
      type: "spring",
      bounce: 0.1,
      duration: 1
    } },
  }
  return (
    <motion.div initial="hidden" whileInView="enter"  viewport={{ once: true, amount: 0.3 }} className="w-full h-full flex justify-center  overflow-hidden lg:hidden pb-[48px] md:pb-[72px]">
    <div className="w-full max-w-[1248px] h-full text-black px-4 lg:px-8 ">
      {/* <motion.h3 variants={variants} className="prodigySans600 text-[20px] md:text-[24px] xl:text-[32px] text-center ">Get started with these <span className="text-[#55a654]">quick</span> steps</motion.h3> */}
      <div className="w-full flex flex-wrap justify-evenly gap-4 ">
       
    {data?.map((info) => (

<HowItworksComponent key={info.id} number={info.id} title={info.header} description={info.description} /> 




      
    ))    
    }
      </div>
    </div>
  </motion.div>
  );
};

export default HowItWorksContainer;
