'use client'
import React, {useState, useEffect, useRef} from "react";
import * as motion from "framer-motion/client"
import ScrubComponent from "./ScrubComponent";
import HowItWorksContainer from "./HowItWorksContainer";
import StepsCard from "./StepsCard";

// const [currentIndex, setCurrentIndex] = useState(0);

const HowItWorks = ({data, cat}) => {
  const variants = {
    hidden: {opacity: 0, x:0, y:20},
    enter: { opacity: 1, x: 0, y: 0,  transition: {
      type: "spring",
      bounce: 0.1,
      duration: .8,
      delay: .1
    } },
  }
  const containerRef = useRef(null);

  return (
    <motion.div initial="hidden" whileInView="enter"  viewport={{ once: true, amount: .05 }} className="w-full h-full flex-col items-center flex justify-center  overflow-hidden pt-[48px] md:pt-[72px]">
      <div className="w-full max-w-[1248px] h-full text-black px-4 lg:px-8 mb-8 lg:mb-12 ">
        <motion.h3 variants={variants} className="prodigySans600 text-[20px] md:text-[24px] xl:text-[32px] text-center ">Get started with these <span className="text-[#55a654]">quick</span> steps</motion.h3>

      </div>

      <StepsCard data={data}  cat={cat} />

      {/* <div className="hidden lg:inline-block">

      <ScrubComponent data={data} ref={containerRef} /> 
      </div> */}
      {/* <div className="lg:hidden inline-block">

      <HowItWorksContainer data={data} /> 
      </div> */}
    </motion.div>
  );
};

export default HowItWorks;
