"use client"
import React from 'react'
import Image from 'next/image';
import client from '../../public/client-survey-img.jpg';
import helper from '../../public/helper-survey-img.jpg';
import Link from "next/link";
import { motion, useScroll } from "framer-motion";
import { FaArrowRight } from 'react-icons/fa';
import { MdArrowRight } from 'react-icons/md';

const variants = {
  hidden: { opacity: 0, x: 0, y: 30 },
  enter: { opacity: 1, x: 0, y: 0,  transition: {
    type: "spring",
    bounce: 0.4,
    duration: 1
  } },
}

const Survey = () => {



  return (
    <div className='w-full flex justify-center px-4 sm:px-8 xl:px-16 py-[48px] md:py-[72px] '>
    <motion.div  initial="hidden"
      whileInView="enter"
      viewport={{ once: true, amount: 0.3 }} className='w-full max-w-[1200px] flex items-center flex-col   '>

        <h3 className='text-[24px] md:text-[28px] xl:text-[32px] font-medium  prodigySans700 tracking-wide'>Take a <span className='text-primaryGreen'>quick</span>  survey</h3>
        <motion.p variants={variants} className='text-[14px] md:text-[16px] w-full max-w-[482px]  prodigySans400 mt-[16px] md:mt-[20px] xl:mt-[24px]'> Let’s serve you better by taking our quick one minute survey.</motion.p>

<div className=''>
<p className='mb-3 mt-6 prodigySans500 text-[12px] md:text-[14px] '>Please select your preferred option: </p>

{/* cards */}
<div className='flex flex-col md:flex-row justify-center items-center gap-9 md:gap-10 '>
<Link href={"https://docs.google.com/forms/d/e/1FAIpQLScjjjbJZBrCNJDjlvhiBATeAFm7AtoekyV1LE7eU_NcyP39lA/viewform?usp=sf_link"} target="_blank" 
        rel="noopener noreferrer" >
<div className='w-fit h-full outline outline-[#ecf2ec] outline-2 rounded-2xl shadow-md pt-1 px-1'>

  <Image src={client} alt='client'  priority className='w-[324px] h-[154px] md:w-[368px] md:h-[180px] p-1 md:p-2 rounded-2xl object-cover ' />
  <div className='w-full bg-[#fcfcfc] flex flex-row items-center py-2 md:py-3 px-2 md:px-4'>
  <p className=' text-[14px] md:text-[16px] font-semibold text-primaryGreen mr-1'>Client</p>
  <FaArrowRight className='text-[14px] md:text-[16px]] text-primaryGreen  hover:translate-x-1 transitiion ease-linear duration-75' />
  </div>

  </div>
 </Link>

 <Link href={"https://forms.gle/D2UE7DaruPgYKwS17"} target="_blank" 
        rel="noopener noreferrer"  >
 <div className='w-fit h-full outline outline-[#ecf2ec] outline-2 rounded-2xl shadow-md pt-1 px-1 '>

  <Image src={helper} alt='helper'  priority className='w-[324px] h-[154px] md:w-[368px] md:h-[180px] p-1 md:p-2  rounded-2xl object-cover ' />
  <div className='w-full bg-[#fcfcfc] flex flex-row items-center py-2 md:py-3 px-2 md:px-4'>
  <p className=' text-[14px] md:text-[16px] font-semibold text-[#55a654] mr-1'>Helper</p>
  <FaArrowRight className='text-[14px] md:text-[16px] text-[#55a654]  hover:translate-x-1 transitiion ease-linear duration-75' />
  </div>

  </div>
 </Link>


</div>
</div>

        </motion.div>
       
</div>
  )
}

export default Survey

