// import React, { useState, useEffect, useMemo } from "react";
// import Image from "next/image";
// import ai from "../../public/ai-assist.png";
// import * as motion from "framer-motion/client";

// const Section4 = () => {
//   const [name, setName] = useState('Helper-AI'); // Default name

//   const variantHeader = {
//     hidden: { opacity: 0, x: 0, y: 30 },
//     enter: {
//       opacity: 1, x: 0, y: 0, transition: {
//         type: "spring",
//         bounce: 0.2,
//         duration: 0.6
//       }
//     },
//   };

//   const variants = {
//     hidden: { opacity: 0, x: -50, y: 0 },
//     enter: {
//       opacity: 1, x: 0, y: 0,
//       transition: {
//         type: "spring",
//         bounce: 0.2,
//         duration: 1.1
//       }
//     },
//   };

//   const transitionValues = {
//     duration: 3,
//     repeat: Infinity,
//     repeatType: 'reverse',
//     ease: "easeOut"
//   };

//   const aiNames = useMemo(() => ['Ingrid', 'Moyo', 'Ayra', 'Tony'], [] );

//   useEffect(() => {
//     let nameIndex = 0;
//     const nameInterval = setInterval(() => {
//       setName(aiNames[nameIndex]);
//       nameIndex = (nameIndex + 1) % aiNames.length;
//     }, 2000);
    
//     return () => clearInterval(nameInterval); // Cleanup interval on unmount
//   }, [aiNames]);

//   return (
//     <motion.div
//       initial="hidden"
//       whileInView="enter"
//       viewport={{ once: true, amount: 0.3 }}
//       className="w-full flex flex-col justify-center items-center py-[48px] md:py-[72px] px-4 sm:px-8 xl:px-16"
//     >
//       <motion.h3 variants={variantHeader} className="font-medium text-[20px] md:text-[24px] xl:text-[32px] prodigySans700 tracking-wide">
//        <span className="text-primaryGreen">Hi, </span>
//         <motion.span
//           key={name} // Ensures re-render on each name change
//           initial={{ opacity: 0, y: -10 }} // Starting state for animation
//           animate={{ opacity: 1, y: 0 }} // Final state for animation
//           transition={{
//             ease: "easeIn", // Applying ease-in effect
//             duration: 0.5 // Duration of animation
//           }}
//           className="text-primaryGreen"
//         >
//            {name}
//         </motion.span>
//         - Customize and chat with your Helper-AI!
//       </motion.h3>
//       <div className="w-full font-poppins flexCenter flex-col sm:flex-row gap-4 md:gap-8 xl:gap-12">
//         <motion.div
//           className="w-fit flexCenter flex-col gap-4 mt-[16px] md:mt-[32px] xl:mt-0"
//         >
//           <motion.p variants={variants} className="w-full max-w-[480px] xl:max-w-[540px] text-[14px] md:text-[16px] prodigySans400 tracking-wide text-justify">
//             Explore the AI assistant feature and discover the benefits of having your personalized AI buddy. Utilize the AI chatroom to seamlessly create tasks, inquire about household, office or other general related queries, enhance your knowledge with your AI buddy, and embrace an easy lifestyle with the <span className="text-[#55a654]">HouseHelpApp.</span>
//           </motion.p>
//         </motion.div>
//         <motion.div
//           transition={{
//             y: transitionValues
//           }}
//           animate={{
//             y: [0, -8, 0],
//           }}
//         >
//           <Image
//             src={ai}
//             alt="chores in lagos"
//             className="w-full max-w-[280px] md:max-w-[320px] xl:max-w-[360px] mt-[48px] md:mt-[56px]"
//           />
//         </motion.div>
//       </div>
//     </motion.div>
//   );
// };

// export default Section4;


import React, { useState, useEffect, useMemo } from "react";
import Image from "next/image";
import ai from "../../public/ai-assist.png";
import * as motion from "framer-motion/client";

const Section4 = () => {
  const [name, setName] = useState('Helper-AI'); // Default name
  const [isImageLoaded, setIsImageLoaded] = useState(false); // State to track image loading

  const variantHeader = {
    hidden: { opacity: 0, x: 0, y: 30 },
    enter: {
      opacity: 1, x: 0, y: 0, transition: {
        type: "spring",
        bounce: 0.2,
        duration: 0.6
      }
    },
  };

  const variants = {
    hidden: { opacity: 0, x: -50, y: 0 },
    enter: {
      opacity: 1, x: 0, y: 0,
      transition: {
        type: "spring",
        bounce: 0.2,
        duration: 1.1
      }
    },
  };

  const transitionValues = {
    duration: 3,
    repeat: Infinity,
    repeatType: 'reverse',
    ease: "easeOut"
  };

  const aiNames = useMemo(() => ['Ingrid', 'Moyo', 'Ayra', 'Tony'], []);

  useEffect(() => {
    let nameIndex = 0;
    const nameInterval = setInterval(() => {
      setName(aiNames[nameIndex]);
      nameIndex = (nameIndex + 1) % aiNames.length;
    }, 2000);

    return () => clearInterval(nameInterval); // Cleanup interval on unmount
  }, [aiNames]);

  const handleImageLoad = () => {
    setIsImageLoaded(true); // Set image loaded state to true
  };

  return (
    <motion.div
      initial="hidden"
      whileInView="enter"
      viewport={{ once: true, amount: 0.3 }}
      className="w-full flex flex-col justify-center items-center py-[48px] md:py-[72px] px-4 sm:px-8 xl:px-16"
    >
      <motion.h3 variants={variantHeader} className="font-medium text-[20px] md:text-[24px] xl:text-[32px] prodigySans700 tracking-wide">
        <span className="text-primaryGreen">Hi, </span>
        <motion.span
          key={name} // Ensures re-render on each name change
          initial={{ opacity: 0, y: -10 }} // Starting state for animation
          animate={{ opacity: 1, y: 0 }} // Final state for animation
          transition={{
            ease: "easeIn", // Applying ease-in effect
            duration: 0.5 // Duration of animation
          }}
          className="text-primaryGreen"
        >
          {name}
        </motion.span>
        - Customize and chat with your Helper-AI!
      </motion.h3>
      <div className="w-full font-poppins flexCenter flex-col sm:flex-row gap-4 md:gap-8 xl:gap-12">
        <motion.div
          className="w-fit flexCenter flex-col gap-4 mt-[16px] md:mt-[32px] xl:mt-0"
        >
          <motion.p variants={variants} className="w-full max-w-[480px] xl:max-w-[540px] text-[14px] md:text-[16px] prodigySans400 tracking-wide text-justify">
            Explore the AI assistant feature and discover the benefits of having your personalized AI buddy. Utilize the AI chatroom to seamlessly create tasks, inquire about household, office or other general related queries, enhance your knowledge with your AI buddy, and embrace an easy lifestyle with the <span className="text-[#55a654]">HouseHelpApp.</span>
          </motion.p>
        </motion.div>
        <motion.div
          transition={{
            y: transitionValues
          }}
          animate={{
            y: [0, -8, 0],
          }}
          className="relative w-full max-w-[280px] md:max-w-[320px] xl:max-w-[360px] mt-[48px] md:mt-[56px]"
        >
          {!isImageLoaded && (
            <div className="absolute inset-0 flexCenter">
              {/* Spinner */}
              <div className="animate-spin rounded-full h-8 w-8 border-b-2 border-gray-900"></div>
            </div>
          )}
          <Image
            src={ai}
            alt="chores in lagos"
            className="w-full max-w-[280px] md:max-w-[320px] xl:max-w-[360px]"
            onLoad={handleImageLoad}
            priority
          />
        </motion.div>
      </div>
    </motion.div>
  );
};

export default Section4;