
"use client"
import React, { useState } from 'react';
import Image from 'next/image';
import { motion } from "framer-motion";
import { clientSection, helperSection } from '@/constants';

const variantsImg = {
  hidden: { opacity: 0, x: -20, y: 0 },
  enter: {
    opacity: 1, x: 0, y: 0,
    transition: {
      type: "spring",
      bounce: 0.2,
      duration: 0.7,
    }
  },
};

const variants = {
  hidden: { opacity: 0, x: 20, y: 0 },
  enter: {
    opacity: 1, x: 0, y: 0,
    transition: {
      type: "spring",
      bounce: 0.2,
      duration: 0.6,
      delay: 0.3
    }
  },
};

const Section3 = () => {
  const [toggle, setToggle] = useState(true);
  const [isImageLoaded, setIsImageLoaded] = useState(false); // State to track image loading

  const handleImageLoad = () => {
    setIsImageLoaded(true); // Set image loaded state to true
  };

  return (
    <motion.div
      initial="hidden"
      whileInView="enter"
      viewport={{ once: true, amount: 0.4 }}
      className='w-full h-full overflow-hidden flexCenter py-[48px] md:py-[72px] px-4 lg:px-8'
    >
      <div className='w-full h-full max-w-fit flexBetween flex-col sm:flex-row md:flexBetweenItemsStretch gap-4 md:gap-8 xl:gap-12'>
        <motion.div variants={variantsImg} className="relative">
          {!isImageLoaded && (
            <div className="absolute inset-0 flexCenter">
              {/* Spinner */}
              <div className="animate-spin rounded-full h-8 w-8 border-b-2 border-gray-900"></div>
            </div>
          )}
          <Image
            src={toggle ? clientSection[0].imgUrl : helperSection[0].imgUrl}
            priority
            alt='user-card-img'
            className='w-full max-w-[340px] md:max-w-[400px] xl:max-w-[480px] h-[302px] md:h-[326px] xl:h-[358px] rounded-[8px] object-cover shadow'
            onLoad={handleImageLoad}
            
          />
        </motion.div>

        <motion.div className='w-fit flex flex-col items-center md:items-start justify-center'>
          <motion.h3
            variants={variants}
            className='w-full max-w-[360px] md:max-w-[386px] xl:max-w-[420px] text-center sm:text-start text-[18px] md:text-[22px] xl:text-[24px] prodigySans600 mb-[16px] md:mb-[20px] xl:mb-[24px]'
          >
            {toggle ? clientSection[0].title : helperSection[0].title}
          </motion.h3>
          <motion.p
            variants={variants}
            className='text-[14px] lg:text-[16px] prodigySans400 w-full mb-2 max-w-[380px] md:max-w-[420px] xl:max-w-[500px]'
          >
            {toggle ? clientSection[0].description : helperSection[0].description}
          </motion.p>
          <div className='w-[134px] h-[44px] bg-[#CDE8CF] mt-8 flex rounded-lg p-1'>
            <div
              className={`w-[63px] h-[36px] ${toggle ? 'bg-white text-primaryGreen' : 'bg-[#F2F2F2] text-[#C4C4C4]'} transition ease-linear duration-[.2s] rounded-l-md flex items-center justify-center font-poppins font-semibold hover:cursor-pointer`}
              onClick={() => setToggle(true)}
            >
              Client
            </div>
            <div
              className={`w-[63px] h-[36px] ${!toggle ? 'bg-white text-[#55a654]' : 'bg-[#F2F2F2] text-[#C4C4C4]'} transition ease-linear duration-[.2s] rounded-r-md flex items-center justify-center font-poppins font-semibold hover:cursor-pointer`}
              onClick={() => setToggle(false)}
            >
              Helper
            </div>
          </div>
        </motion.div>
      </div>
    </motion.div>
  );
};

export default Section3;