"use client"
import React from 'react'
import * as motion from "framer-motion/client"


const variantsHeader = {
  hidden: { opacity: 0, x: 0, y: 40 },
  enter: { opacity: 1, x: 0, y: 0,  transition: {
    type: "spring",
    bounce: 0.2,
    duration: 1
  } },
}
const variants = {
  hidden: { opacity: 0, x: 0, y: 50 },
  enter: { opacity: 1, x: 0, y: 0,  transition: {
    type: "spring",
    bounce: 0.2,
    duration: 1,
    delay: .2
  } },
}



const Section2 = () => {

  return (
    // outline outline-orange-300
    <div className='w-full flexCenter px-4 '>
        <motion.div  initial="hidden"
      whileInView="enter"
      viewport={{ once: true, amount: 0.4 }} className='w-full  flexCenter flex-col py-[0px] md:py-[0px]'>
   
  
            <motion.h2 variants={variantsHeader}  className='text-[24px] md:text-[28px] xl:text-[32px] text-[#1c1c1c] prodigySans700 tracking-wide'>Welcome to the <spa className='text-primaryGreen'>easy</spa> side </motion.h2>
            <motion.p variants={variants} className='text-[14px] md:text-[16px] xl:text-[16px] mt-[16px] md:mt-[20px] xl:mt-[24px] w-full max-w-[624px] sm:max-w-[872px] prodigySans400 tracking-wide '> <span className='prodigySans500 text-primaryGreen'>HouseHelpApp</span> makes life easier by connecting you with skilled, on-demand service providers for  <span className='font-medium'>household chores</span>, <span className='font-medium'>work-related tasks</span>, and <span className='font-medium'>food delivery to your doorstep</span>. Our vetted professionals get the job done, and payment is made securely after completion. <br /> <br />
            {/* <span className='font-semibold italic text-[12px] md:text-[14px]'>Everyone needs help...</span>  */}
            </motion.p>
            </motion.div>
           
    </div>
  )
}

export default Section2

// max-w-[680px] xl:


// referred to as <span  className='prodigySans500 text-primaryGreen'>Helpers</span>