'use client'
import React, { useEffect, useState } from 'react'
import Image from 'next/image'
import { motion } from "motion/react"
import { AnimatePresence } from 'framer-motion'
import { categories } from '@/constants'
import { imageTagArray } from '@/constants/data'

const Hero2 = () => {
  const [currentIndex, setCurrentIndex] = useState(0)
  const [isImageLoaded, setIsImageLoaded] = useState(false)

  // Animation variants
  const variants = {
    hidden: { opacity: 0, x: 0, y: 60 },
    enter: { 
      opacity: 1, 
      x: 0, 
      y: 0, 
      transition: {
        type: "spring",
        bounce: 0.1,
        duration: 1
      }
    }
  }

  const variantsImg = {
    hidden: { opacity: 0, x: 0, y: 120 },
    enter: { 
      opacity: [0.2, 0.65, 1], 
      x: 0, 
      y: 0, 
      transition: {
        type: "spring",
        duration: 1,
        ease: 'easeIn',
        stagger: 2
      }
    }
  }

  const visibilityVariants = {
    hidden: { opacity: 0 },
    visible: {
      opacity: 1,
      transition: {
        duration: 1,
        ease: 'easeInOut'
      }
    }
  }

  const variantLargeImg = {
    initial: { opacity: 0, scale: 0.8 },
    animate: { 
      opacity: 1, 
      scale: 1, 
      transition: { 
        duration: 0.3, 
        ease: 'easeInOut' 
      } 
    },
    exit: { 
      opacity: 0, 
      scale: 0.8, 
      transition: { 
        duration: 0.1, 
        ease: 'easeIn' 
      } 
    }
  }

  const handleImageLoad = () => {
    setIsImageLoaded(true)
  }

  const categoryLoop = () => {
    setCurrentIndex(prevIndex => 
      prevIndex === categories.length - 1 ? 0 : prevIndex + 1
    )
  }

  useEffect(() => {
    const interval = setInterval(categoryLoop, 6000)
    return () => clearInterval(interval)
  }, [])

  return (
    <div className='w-full h-fit overflow-hidden flexCenter pt-[124px] md:pt-[148px] pb-[48px] md:pb-[72px] relative px-4 lg:px-8 xl:px-16'>
      <motion.div 
        initial="hidden" 
        whileInView="enter" 
        viewport={{ once: true, amount: 0.6 }} 
        className='w-full max-container-1248 font-poppins flexCenter flex-col md:justify-between gap-4'
      >
        {/* Text Content */}
        <div className='h-fit flexCenter flex-col relative w-full'>
          <motion.h1 
            variants={variants} 
            className='w-fit max-w-[360px] md:max-w-[480px] text-center text-[32px] md:text-[36px] xl:text-[42px] prodigySans700 tracking-wide'
          >
            <span className='text-primaryGreen'>Simplify</span> your day with HouseHelpApp
          </motion.h1>
          
          <motion.h2 
            variants={variants} 
            className='w-fit max-w-[360px] md:max-w-[402px] xl:max-w-[434px] text-center text-[18px] md:text-[20px] xl:text-[22px] prodigySans400 tracking-wide mt-[16px] md:mt-[20px] xl:mt-[24px] mb-[4px] md:mb-[8px] xl:mb-[16px]'
          >
            Easily connect with trusted professionals for all your everyday needs.
          </motion.h2>
          
          <motion.h3 
            variants={variants} 
            className='w-fit text-[16px] md:text-[18px] xl:text-[20px] text-center prodigySans400 tracking-wide'
          >
            You need <span className='text-primaryGreen font-semibold'>{categories[currentIndex]?.name} ?</span>
          </motion.h3>

          {/* Desktop Image Tags */}
          <div className="absolute hidden md:flex flex-col items-stretch w-full max-w-[1042px] h-full max-h-[240px] top-0 px-1 z-0">
            <AnimatePresence>
              {imageTagArray.map((item, index) => (
                currentIndex === index && (
                  <motion.div
                    key={item.id}
                    className="flex flex-col justify-between h-full"
                    initial="hidden"
                    animate="visible"
                    exit="hidden"
                    variants={visibilityVariants}
                  >
                    {[1, 2, 3].map(row => (
                      <div key={`row-${row}`} className="flex flex-row w-full items-center justify-between">
                        <motion.div variants={visibilityVariants}>
                          <Image
                            src={item[`tag${row*2-1}`]}
                            alt={`tag${row*2-1}`}
                            className="w-full h-[32px] max-h-fit max-w-fit float-left -rotate-3"
                          />
                        </motion.div>
                        <motion.div variants={visibilityVariants}>
                          <Image
                            src={item[`tag${row*2}`]}
                            alt={`tag${row*2}`}
                            className="w-full h-[32px] max-h-fit max-w-fit float-right rotate-[7deg]"
                          />
                        </motion.div>
                      </div>
                    ))}
                  </motion.div>
                )
              ))}
            </AnimatePresence>
          </div>
        </div>

        {/* Image Content */}
        <motion.div variants={variantsImg} className='w-fit h-fit'>
          {/* Desktop Images */}
          <div className="sm:flex hidden flex-row w-full h-[478px] overflow-hidden rounded-lg mt-8">
            <AnimatePresence>
              {imageTagArray.map((item) => (
                <motion.div
                  key={item.id}
                  className="w-full h-full relative"
                >
                  <AnimatePresence mode="wait">
                    {imageTagArray[currentIndex].id !== item.id && (
                      <motion.div
                        key={`backdrop-${item.id}`}
                        className="absolute w-full h-full bg-[#c6c6c6c9] backdrop-blur-xl"
                        variants={variantLargeImg}
                        initial="initial"
                        animate="animate"
                        exit="exit"
                      />
                    )}
                  </AnimatePresence>
                  <Image
                    src={item.imgUrl}
                    className="w-full max-w-[380px] h-full object-cover"
                    alt={item.type}
                    priority
                  />
                </motion.div>
              ))}
            </AnimatePresence>
          </div>

          {/* Mobile Image */}
          <div className='sm:hidden flex w-full h-fit'>
            {!isImageLoaded && (
              <div className="absolute inset-0 flexCenter">
                <div className="animate-spin rounded-full h-8 w-8 border-b-2 border-gray-900"></div>
              </div>
            )}
            <Image 
              src={categories[currentIndex]?.img_url} 
              alt={categories[currentIndex]?.id} 
              onLoad={handleImageLoad} 
              className='w-full max-w-[316px] md:max-w-[386px] xl:max-w-[466px] mt-[30px]' 
              priority 
            />
          </div>
        </motion.div>
      </motion.div>
    </div>
  )
}

export default Hero2




