'use client'
import React, { useEffect, useState } from 'react'
import Image from 'next/image';
import chores from '../../public/chores-img.png'
import { categories } from '@/constants'
import * as motion from "framer-motion/client"

const Hero = () => {

  const [currentIndex, setCurrentIndex] = useState(0);

  const variants = {
    hidden: { opacity: 0, x: 0, y: 60 },
    enter: { opacity: 1, x: 0, y: 0, transition: {
      type: "spring",
      bounce: 0.1,
      duration: 1
    }},
  };

  const variantsImg = {
    hidden: { opacity: 0, x: 120, y: 0 },
    enter: { opacity: 1, x: 0, y: 0, transition: {
      type: "spring",
      bounce: 0.2,
      duration: 1,
      delay: 0.5
    }},
  };

  const categoryLoop = () => {
    setCurrentIndex(prevIndex =>
      prevIndex === categories.length - 1 ? 0 : prevIndex + 1
    );
  };

  useEffect(() => {
    const interval = setInterval(() => {
      categoryLoop();
    }, 6000);

    return () => clearInterval(interval);
  }, []); // Adding an empty dependency array here

  return (
    <div className='w-full fleCenter pt-[124px] md:pt-[148px] pb-[48px] md:pb-[72px] relative px-4 lg:px-8 xl:px-16'>
      <motion.div initial="hidden" whileInView="enter" viewport={{ once: true, amount: 0.6 }} className='w-full max-container-1248 font-poppins flexCenter flex-col sm:flex-row  md:justify-between gap-4'>
        <div className='h-fit'>
          <motion.h1 variants={variants} className='w-full max-w-[360px] md:max-w-[480px] text-[32px] md:text-[36px] xl:text-[42px] prodigySans700 tracking-wide'>
            <span className='text-primaryGreen'>Simplify</span> your day with HouseHelpApp
          </motion.h1>
          <motion.h2 variants={variants} className='w-full max-w-[360px] md:max-w-[480px] text-[18px] md:text-[20px] xl:text-[22px] prodigySans400 tracking-wide mt-[16px] md:mt-[20px] xl:mt-[24px] mb-[4px] md:mb-[8px] xl:mb-[16px]'>
          Easily connect with trusted professionals for all your <span>everyday needs.</span>
          </motion.h2>
          <motion.h3 variants={variants} className='text-[16px] md:text-[18px] xl:text-[20px] mt-[14px] md:mt-[16px] prodigySans400 tracking-wide '>
           You need <span className='text-primaryGreen font-semibold'>{categories[currentIndex]?.name} ?</span>
          </motion.h3>
        </div>
        <motion.div variants={variantsImg} className='w-fit h-fit'>
          <Image src={categories[currentIndex]?.img_url} alt='chores in lagos' className='w-full max-w-[316px] md:max-w-[386px] xl:max-w-[466px] mt-[30px]' priority />
        </motion.div>
      </motion.div>
    </div>
  );
}

export default Hero;
