// "use client"
// import React from 'react'
// import Image from 'next/image';
// import iphone from '../../public/download.png';
// import Form from './Form';
// import { motion, useScroll } from "framer-motion";
// import appStore from '@/public/appstore.svg'
// import playStore from '@/public/playstore.svg'

// const variants = {
//   hidden: { opacity: 0, x: 0, y: 50 },
//   enter: { opacity: 1, x: 0, y: 0,  transition: {
//     type: "spring",
//     bounce: 0.4,
//     duration: 1
//   } },
// }

// const Download = () => {
//   return (
//     <div className='w-full flex justify-center px-6 sm:px-12'>
//     <div className='w-full max-w-[1048px] h-full max-h-[1000px] md:max-h-[512px] flex items-center flex-col bg-[#193E43] px-4  rounded-2xl '>
//         <motion.div  initial="hidden"
//       whileInView="enter"
//       viewport={{ once: true, amount: 0.4 }} className='flexCenter flex-col  md:flex-row justify-between overflow-hidden md:gap-16'>
//             <motion.div variants={variants} className='flex flex-col  text-white w-full max-w-[476px] py-[40px] md:py-[70px]'>
//                 {/* <h5 className='text-[24px]  prodigySans700'>Get the Help You Need – Download HouseHelpApp Today!</h5> */}
//                 <h5 className='text-[24px]  prodigySans700'>Get the Help You Need – Coming to your favorite app stores!</h5>
//                 <p className='text-[14px] w-full max-w-[390px] prodigySans500 pt-4'>HouseHelpApp would soon be available for download! Connect with skilled professionals or offer your services to grow your community and earn.</p>
//                 {/* <p className='text-[14px] w-full max-w-[390px] prodigySans500 pt-4'>HouseHelpApp is now available for download! Connect with skilled professionals or offer your services to grow your community and earn.</p> */}
//                 {/* <p className='text-[14px] font-medium pt-2 '>Make money with your professional skillsets and services, help to grow your community.</p> */}

//           <Form />
//           <div className='flex flex-col sm:flex-row items-center justify-center md:justify-start gap-3 pt-4'>
            
//               <br />
//               <br />
   
//             {/* <Image src={appStore} alt='appstore download btn' className='w-full max-w-[140px]' />
//             <Image src={playStore} alt='playstore download btn' className='w-full max-w-[140px]' /> */}
//           </div>
//             </motion.div>
//             <Image src={iphone} alt='app-homescreen' className='w-full h-full max-w-[208px]  '/>

//         </motion.div>

//         </div>
       
// </div>
//   )
// }

// export default Download

// {/* <Image src={iphone} alt='' className='w-full h-full max-w-[183px] max-h-[369px] my-auto'/> */}
// // 357934



"use client"
import React, { useState } from 'react';
import Image from 'next/image';
import iphone from '../../public/download.png';
import Form from './Form';
import { motion } from "framer-motion";
import appStore from '@/public/appstore.svg';
import playStore from '@/public/playstore.svg';

const variants = {
  hidden: { opacity: 0, x: 0, y: 50 },
  enter: {
    opacity: 1, x: 0, y: 0,
    transition: {
      type: "spring",
      bounce: 0.4,
      duration: 1
    }
  },
};

const Download = () => {
  const [isImageLoaded, setIsImageLoaded] = useState(false); // State to track image loading

  const handleImageLoad = () => {
    setIsImageLoaded(true); // Set image loaded state to true
  };

  return (
    <div className='w-full flex justify-center px-6 sm:px-12'>
      <div className='w-full max-w-[1048px] h-full max-h-[1000px] md:max-h-[512px] flex items-center flex-col bg-[#193E43] px-4 rounded-2xl'>
        <motion.div
          initial="hidden"
          whileInView="enter"
          viewport={{ once: true, amount: 0.4 }}
          className='flexCenter flex-col md:flex-row justify-between overflow-hidden md:gap-16'
        >
          <motion.div variants={variants} className='flex flex-col text-white w-full max-w-[476px] py-[40px] md:py-[70px]'>
            <h5 className='text-[24px] prodigySans700'>Get the Help You Need – Coming to your favorite app stores!</h5>
            <p className='text-[14px] w-full max-w-[390px] prodigySans500 pt-4'>
              HouseHelpApp would soon be available for download! Connect with skilled professionals or offer your services to grow your community and earn.
            </p>
            <Form />
            <div className='flex flex-col sm:flex-row items-center justify-center md:justify-start gap-3 pt-4'>
              <br />
              <br />
              {/* Placeholder for app store buttons */}
            </div>
          </motion.div>

          {/* Image Container with Spinner */}
          <div className="relative w-full max-w-[208px] h-full">
            {!isImageLoaded && (
              <div className="absolute inset-0 flexCenter">
                {/* Spinner */}
                <div className="animate-spin rounded-full h-8 w-8 border-b-2 border-gray-900"></div>
              </div>
            )}
            <Image
              src={iphone}
              alt='app-homescreen'
              className='w-full h-full max-w-[208px]'
              onLoad={handleImageLoad}
            />
          </div>
        </motion.div>
      </div>
    </div>
  );
};

export default Download;