// 'use client'
// import React, { useState, useRef } from "react";
// import Image from 'next/image'
// import mosaic from '@/public/logo-mosaic.png'
// import { CardDisplay } from '@/constants'

// const CardDisplaySection = () => {
//     const [isHovered, setIsHovered] = useState(null);
//     const cardRef = useRef({});

//     // Define styles for showing and hiding the card front and back
//     const frontStyle = { 
//         transition: 'opacity 0.6s ease-in-out',
//         position: 'absolute',
//         top: 0,
//         left: 0,
//         width: '100%',
//         height: '100%'
//     };

//     const backStyle = { 
//         transition: 'opacity 0.6s ease-in-out',
//         position: 'absolute',
//         top: 0,
//         left: 0,
//         width: '100%',
//         height: '100%'
//     };

//     const handleMouseEnter = (id) => {
//         setIsHovered(id);
//     }

//     const handleMouseLeave = () => {
//         setIsHovered(null);
//     }

//     return (
//         <div className='w-full h-full overflow-hidden rounded-t-[42px] bg-[#193E43] pt-[72px]'>
//             <div className='w-full flex flex-col items-center justify-center'>
//                 <h3 className='text-white prodigySans600 text-[24px] md:text-[26px] xl:text-[28px]'>
//                     One-Stop Marketplace for Outsourcing Any Task
//                 </h3>
//                 <p className='text-white w-[446px] text-[16px] mt-[16px] prodigySans400'>
//                     No matter the task, a helper is always just one click away. Or, turn your skills into income by becoming a service provider.
//                 </p>
//             </div>
            
//             <div className='w-[1800px] h-[274px] flex flex-row gap-x-4 relative overflow-hidden'>
//                 {/* Card container */}
//                 {CardDisplay.map((card) => (
//                     <div key={card.id} className='w-full max-w-[326px] md:max-w-[364px] xl:max-w-[425px] h-[262px] relative'
//                          onMouseEnter={() => handleMouseEnter(card.id)} 
//                          onMouseLeave={handleMouseLeave}>
                         
//                         {/* Front of the card */}
//                         <div className='bg-helper w-full h-full bg-cover rounded-lg pt-2 pl-2' 
//                              style={{ ...frontStyle, opacity: isHovered === card.id ? 0 : 1 }}>
//                             <p className='bg-[#55a654c7] text-white py-2 px-2 rounded w-fit font-medium'>
//                                 {card.name}
//                             </p>
//                         </div>

//                         {/* Back of the card */}
//                         <div className='bg-white w-full h-full flex flex-col items-center py-[24px] shadow-md rounded-lg'
//                              style={{ ...backStyle, opacity: isHovered === card.id ? 1 : 0 }}>
//                             <div className='w-[149px] h-[44px] bg-[#55a65420] flex rounded items-center justify-center'>
//                                 <p className='font-fraunces font-bold text-[24px]'>{card.name}</p>
//                             </div>
//                             <ul className='grid grid-cols-3 gap-y-2 gap-x-6 mt-6'>
//                                 {card.jobType.map((list, index) => (
//                                     <li key={index} className='text-[10px] hover:scale-[1.1] transition-all font-medium'>
//                                         {list}
//                                     </li>
//                                 ))}
//                             </ul>
//                             <span className='prodigySans500 text-[#000] text-[10px] absolute bottom-2'>
//                                 Do more with <span className='text-[#55a654] prodigySans600'>HouseHelpApp</span>
//                             </span>
//                         </div>
//                     </div>
//                 ))}
//             </div>

//             <Image src={mosaic} alt="Mosaic Logo" className='w-full' />
//         </div>
//     )
// }

// export default CardDisplaySection;





'use client'
import React, { useState, useRef } from "react";
import Image from 'next/image';
import mosaic from '@/public/logo-mosaic.png';
import { CardDisplay } from '@/constants';
import * as motion from "framer-motion/client"

const CardDisplaySection = () => {
    const [isHovered, setIsHovered] = useState(null);
    const carouselRef = useRef(null);

    const variants = {
        hidden: {opacity: 0, x:0, y:20},
        enter: { opacity: 1, x: 0, y: 0,  transition: {
          type: "spring",
          bounce: 0.1,
          duration: .6
        } },
      }

    // Define styles for front and back of the cards
    const frontStyle = { 
        transition: 'opacity 0.2s ease-linear',
        position: 'absolute',
        top: 0,
        left: 0,
        width: '100%',
        height: '100%',
    };

    const backStyle = { 
        transition: 'opacity 0.2s ease-linear',
        position: 'absolute',
        top: 0,
        left: 0,
        width: '100%',
        height: '100%',
    };

    const handleMouseEnter = (id) => {
        setIsHovered(id);
    };

    const handleMouseLeave = () => {
        setIsHovered(null);
    };

    return (
        <motion.div initial="hidden" whileInView="enter"  viewport={{ once: true, amount: .4 }}  className='w-full h-full overflow-hidden rounded-t-[42px] bg-[#193E43] pt-[72px]  flex items-center justify-center flex-col relative'>
            <div className='w-full flex flex-col items-center justify-center px-4'>
                <motion.h3 variants={variants} className='text-white prodigySans600  text-[24px] md:text-[26px] xl:text-[28px]'>
                    One-Stop Marketplace for Outsourcing Any Task
                </motion.h3>
                <motion.p variants={variants} className='text-white w-full max-w-[446px] text-[16px] mt-[16px] prodigySans400'>
                    No matter the task, a helper is always just one click away. Or, turn your skills into income by becoming a service provider.
                </motion.p>
            </div>

            {/* Horizontal Scrollable Carousel */}
            <div
                className='w-full max-w-[1600px] h-[274px] pl-12 flex overflow-x-auto scrollbar-hide relative z-10 mt-16 mb-12 '
                ref={carouselRef}
            >
                {CardDisplay.map((card, index) => (
                    <div 
                        key={index} 
                        className='flex-shrink-0 w-[326px] md:w-[364px] xl:w-[425px] h-[262px] relative mx-2'
                        onMouseEnter={() => handleMouseEnter(card.id)} 
                        onMouseLeave={handleMouseLeave}
                    >
                        {/* Front of the card */}
                        <div 
                        
                            className={` w-full h-full bg-cover rounded-lg pt-2 pl-2` }
                            style={{ 
                                backgroundImage: `url(${card.imgUrl})`,
                                ...frontStyle, 
                                opacity: isHovered === card.id ? 0 : 1 
                            }}
                        >
                            <p className='bg-[#55a654c7] text-[12px] md:text-[14px] text-white py-2 px-2 rounded w-fit font-medium'>
                                {card.name}
                            </p>
                        </div>

                        {/* Back of the card */}
                        <div 
                            className='bg-white w-full h-full flex flex-col items-center py-[24px] px-1 md:px-2 shadow-md rounded-lg'
                            style={{ 
                                ...backStyle, 
                                opacity: isHovered === card.id ? 1 : 0 
                            }}
                        >
                            {/* <div className='w-[149px] h-[44px] bg-[#55a65420] flex rounded items-center justify-center'> */}
                                <p className='bg-[#55a65420] py-2 px-2 font-fraunces font-bold text-center text-[18px]'>{card.name}</p>
                            {/* </div> */}
                            <ul className='grid grid-cols-3 gap-y-2 md:gap-y-3 gap-x-4 mt-6'>
                                {card.jobType.map((list, idx) => (
                                    <li 
                                        key={idx} 
                                        className='text-[10px] hover:scale-[1.05] hover:text-[#55a654] hover:font-medium transition-all font-medium cursor-pointer'
                                    >
                                        {list}
                                    </li>
                                ))}
                            </ul>
                            <span className='prodigySans500 text-[#000] text-[8px] absolute bottom-2'>
                                Do more with <span className='text-[#55a654] prodigySans600'>HouseHelpApp</span>
                            </span>
                        </div>
                    </div>
                ))}
            </div>

            <Image src={mosaic} alt="Mosaic Logo" className='w-full h-[118px]  md:h-[157px] absolute bottom-0' />
        </motion.div>
    );
}

export default CardDisplaySection;

