'use client'
import React, {useState, useEffect} from 'react';
// import { motion, useScroll } from "framer-motion"
import * as motion from "framer-motion/client"
import BlogCardComponent from '../BlogCardComponent';


const variants = {
  hidden: { opacity: 0, x: 0, y: 30 },
  enter: { opacity: 1, x: 0, y: 0,  transition: {
    type: "spring",
    bounce: 0.3,
    duration: 1
  } },
}


const Blog = ({posts}) => {
  const [no_Of_Element, setNo_Of_Element] = useState(4);
  const pageDisplay = 'HomePage'

  return (
    <div className='w-full flexCenter px-4 py-[48px] md:py-[72px]'>
    <div className='w-full max-w-[1200px] font-poppins flex flex-col items-center justify-center md:justify-between'>
    <motion.div  initial="hidden"
      whileInView="enter"
      viewport={{ once: true, amount: 0.6 }}   className='w-full flex flex-col items-center mb-12'>
      <div  className='w-full flex flex-row justify-center items-center'>
      <motion.h3 variants={variants} className='font-semibold text-[24px] md:text-[32px] prodigySans700 tracking-wide'>News <span className='text-[#55a654]'>&</span> Articles</motion.h3>
      {/* <Link href={'https://blog.househelpapp.com'}><p className='text-[14px] cursor-pointer  p-[.5rem] hover:bg-[#f6f6f6] rounded-lg '>visit blog</p></Link> */}
      </div>
       
      <motion.p variants={variants} className='text-[14px] md:text-[16px] w-full max-w-[872px] mt-[24px] prodigySans400 tracking-wide ' >
      Discover how to make the most of the HouseHelpApp and enhance your daily life. Explore valuable tips and DIY solutions for your everyday needs, including laundry services, food orders, house cleaning, pest control, hair and beauty services, and more.
      </motion.p>

    </motion.div>

  <BlogCardComponent posts={posts} no_Of_Element={no_Of_Element} pageDisplay={pageDisplay}  />
    </div>
  
</div>
  )
}

export default Blog