/* eslint-disable react/no-unescaped-entities */
import React from 'react'
import * as motion from "framer-motion/client"

const Section2 = () => {
  const variants = {
    hidden: { opacity: 0, x: 0, y: 50 },
    enter: { opacity: 1, x: 0, y: 0,  transition: {
      type: "spring",
      bounce: 0.2,
      duration: 1,
      delay: .1
    } },
  }
  
  return (
    <motion.div  initial="hidden"
    whileInView="enter"
    viewport={{ once: true, amount: 0.6 }}  className='w-full flexCenter px-4 sm:px-8'>
        <div className='w-full max-w-[1000px] flex items-center flex-col mt-[56px]  '>
   
            <motion.p variants={variants} className='text-[14px] md:text-[16px] xl:text-[16px] w-full max-w-[624px] sm:max-w-[872px] prodigySans400 text-justify'> Unlock opportunities as a <span className='text-[#55a654] font-medium'>Helper</span> today! Take control of your career by accepting on-demand job requests tailored to your unique skills and earn an income on your terms. Whether you’re an individual professional or a small business, there’s a need for experts like you—plumbers, tailors, carpenters, personal shoppers, fitness instructors, cleaners, maintenance specialists, and more. Join today and connect with clients seeking your specialized expertise. </motion.p>
            </div>
           
    </motion.div>
  )
}

export default Section2


// max-w-[780px] xl: