

/* eslint-disable react/no-unescaped-entities */
import React, { useState } from 'react';
import Image from 'next/image';
import male from '@/public/helper-man-layer.png';
import * as motion from "framer-motion/client";

const Hero = () => {
  const [isImageLoaded, setIsImageLoaded] = useState(false); // State to track image loading

  const handleImageLoad = () => {
    setIsImageLoaded(true); // Set image loaded state to true
  };

  const variants = {
    hidden: { opacity: 0, x: 0, y: 60 },
    enter: {
      opacity: 1, x: 0, y: 0,
      transition: {
        type: "spring",
        bounce: 0.1,
        duration: 1
      }
    },
  };

  const variantsImg = {
    hidden: { opacity: 0, x: 60, y: 0 },
    enter: {
      opacity: 1, x: 0, y: 0,
      transition: {
        type: "spring",
        bounce: 0.2,
        duration: 1,
        delay: 0.25
      }
    },
  };

  return (
    <motion.div
      initial="hidden"
      whileInView="enter"
      viewport={{ once: true, amount: 0.6 }}
      className="w-full h-full flexCenter pt-[124px] md:pt-[148px] pb-[48px] md:pb-[72px] xl:pb-[148px] bg-[#e3f3f4] overflow-hidden px-4 md:px-8"
    >
      <div className="w-full h-full max-container-1248 text-[#1c1c1c] flexBetween flex-col md:flex-row">
        <div>
          <motion.div variants={variants}>
            <h2 className='prodigySans700 text-[28px] md:text-[36px] xl:text-[42px] max-w-[584px]'>
              Make extra income with HouseHelpApp and <span className='text-[#55a654]'>keep every penny you earn.</span>
            </h2>
            <h3 className='prodigySans400 text-[18px] md:text-[20px] xl:text-[22px] max-w-[480px] pt-[26px]'>
              We don't take any commission - that's right, you get to keep 100% of your earnings!
            </h3>
          </motion.div>
        </div>

        {/* Image Container with Spinner */}
        <motion.div variants={variantsImg} className='pt-12 lg:pt-0 relative'>
          {!isImageLoaded && (
            <div className="absolute inset-0 flexCenter">
              {/* Spinner */}
              <div className="animate-spin rounded-full h-8 w-8 border-b-2 border-gray-900"></div>
            </div>
          )}
          <Image
            src={male}
            alt='chores in lagos'
            className='w-full h-full max-w-[218px] md:max-w-[282px] xl:max-w-[364px]'
            priority
            onLoad={handleImageLoad}
          />
        </motion.div>
      </div>
    </motion.div>
  );
};

export default Hero;