import React from "react";
import Image from "next/image";
import footerImg from "@/public/footer-icon.svg";
import Link from "next/link";
import { footerLinks, footerSocialLinks } from "@/constants";


const Footer = () => {
  return (
    <div className="w-full flex justify-center items-center ">
      <div className="w-full flex flex-col justify-center max-w-[1800px] h-full text-white bg-[#111] relative pt-16">
        <div className="flex w-full flex-wrap flex-col lg:flex-row justify-center lg:justify-between items-center lg:items-stretch px-[24px] sm:px-[40px] lg:px-[80px] gap-x-12 gap-y-8">
          <Image
            src={footerImg}
            alt="Footer Logo"
            className="w-full h-full max-w-[140px] md:max-w-[180px] max-h-[63px]"
          />

          <div className="flex flex-wrap justify-center gap-12 lg:gap-16">
            {/* Products */}
            <div>
              <h4 className="text-lg font-semibold mb-4">Products</h4>
              <ul className="flex flex-col gap-2">
                {footerLinks.products.map((nav, index) => (
                  <li
                    key={index}
                    className="text-[13px] md:text-[14px] font-medium hover:cursor-pointer hover:scale-105 hover:text-[#81d27f] transform ease-linear duration-75"
                  >
                    <Link href={nav.link}>{nav.name}</Link>
                  </li>
                ))}
              </ul>
            </div>

            {/* Resources */}
            <div>
              <h4 className="text-lg font-semibold mb-4">Resources</h4>
              <ul className="flex flex-col gap-2">
                {footerLinks.resources.map((nav, index) => (
                  <li
                    key={index}
                    className="text-[13px] md:text-[14px] font-medium hover:cursor-pointer hover:scale-105 hover:text-[#81d27f] transform ease-linear duration-75"
                  >
                    <Link href={nav.link}>{nav.name}</Link>
                  </li>
                ))}
              </ul>
            </div>

            {/* Legal */}
            <div>
              <h4 className="text-lg font-semibold mb-4">Legal</h4>
              <ul className="flex flex-col gap-2">
                {footerLinks.legal.map((nav, index) => (
                  <li
                    key={index}
                    className="text-[13px] md:text-[14px] font-medium hover:cursor-pointer hover:scale-105 hover:text-[#81d27f] transform ease-linear duration-75"
                  >
                    <Link href={nav.link}  target="_blank" rel="noopener noreferrer">{nav.name}</Link>
                  </li>
                ))}
              </ul>
            </div>
          </div>

          <div className="flex flex-col">
            {/* Social Links */}
            <ul className="flex justify-start gap-5 lg:gap-4">
              {footerSocialLinks.map((nav, index) => (
                <li
                  key={index}
                  className="text-[13px] md:text-[14px] font-medium hover:cursor-pointer hover:scale-150 hover:text-[#81d27f] transform ease-linear duration-75"
                >
                  <Link href={nav.link} target="_blank" rel="noopener noreferrer">{nav.icon}</Link>
                </li>
              ))}
            </ul>

            {/* Contact Info */}
            <p className="font-normal text-[12px] pt-3 md:pt-5">
              Contact us <br />
              <span className="font-medium">support@househelpapp.com</span>
            </p>
          </div>
        </div>

        <p className="font-normal text-[10px] text-center py-8">
          Copyright © 2024 Luke Engine Limited
        </p>
      </div>
    </div>
  );
};

export default Footer;
