// 'use client'
// import React, {useState } from 'react';
// import Link from 'next/link';

// const Dropdown = ({ options, onSelect, placeholder = "All articles", page }) => {
//   const [isOpen, setIsOpen] = useState(false);
//   const [selected, setSelected] = useState(null);



//   const handleSelect = (option) => {

    
//     setSelected(option.name); // Use the 'name' property for display
//     setIsOpen(false);
//     if (onSelect) onSelect(option); // Pass the entire object to the callback
//   };

//   return (
//     <div className="dropdown w-full min-w-[240px] ">
//       <div 
//            className={`dropdown-header hover:shadow transform ease-linear duration-75 ${!selected ? "placeholder" : ""}`}
//            onClick={() => setIsOpen((prev) => !prev)} 
//       >
 
//         <p className='text-center w-full'>{page === 'all-articles' ? placeholder : page}</p>
//         <div  className='w-fit'>

//         <span    className={`arrow  ${isOpen ? "up" : "down"}`}></span>
//         </div>
//       </div>

//       {isOpen && (
//         <ul className="dropdown-list">
//           {options.map((option, index) => (
//               <Link key={index}   href={`/blog/category/${option.slug}`}>
//               <li 
              
//               className="dropdown-item" 
//               onClick={() => handleSelect(option)}
//             >
//                     {option.name} 
            
//             </li>
//             </Link>
//           ))}
//         </ul>
//       )}
//       <style jsx>{`
//         .dropdown {
//           position: relative;
//         //   width: 200px;
//           cursor: pointer;
//         }
//         .dropdown-header {
//           padding: 10px;
//         //   border: 1px solid #f0f0f0;
//           border-radius: 4px;
//         //   background: #fff;
//           display: flex;
//           justify-content: space-between;
//           align-items: center;
//         }
//           .dropdown-header.placeholder {
//     font-family: prodigySans; 
//     font-weight: 600;  
//       font-style: italic;
//       color: #55a654f2; /* Placeholder text color */
//       font-size: 20px; /* Placeholder font size */
//     }
//         .arrow {
//           margin-left: 10px;
//           border: solid black;
//           border-width: 0 2px 2px 0;
//           display: inline-block;
//           padding: 3px;
          
//         }
//         .arrow.up {
//           transform: rotate(-135deg);
//         }
//         .arrow.down {
//           transform: rotate(45deg);
//         }
//         .dropdown-list {
//           position: absolute;
//           top: 100%;
//           left: 0;
//           right: 0;
//           background: #fff;
//           border: 1px solid #ccc;
//           max-height: 150px;
//           overflow-y: auto;
//           z-index: 1000;
//         }
//         .dropdown-item {
//           padding: 10px;
//           border-bottom: 1px solid #f0f0f0;
//         }
//         .dropdown-item:hover {
//           background: #f5f5f5;
//         }
//       `}</style>
//     </div>
//   );
// };

// export default Dropdown;




'use client'
import React, { useState, useEffect, useRef } from 'react';
import Link from 'next/link';
import { motion, AnimatePresence } from 'framer-motion';
import { FiChevronDown, FiChevronUp } from 'react-icons/fi';

const Dropdown = ({ 
  options, 
  onSelect, 
  placeholder = "All articles", 
  page,
  currentSlug
}) => {
  const [isOpen, setIsOpen] = useState(false);
  const [selected, setSelected] = useState(null);
  const dropdownRef = useRef(null);

  // Set initial selected option based on currentSlug
  useEffect(() => {
    if (currentSlug && options) {
      const currentOption = options.find(opt => opt.slug === currentSlug);
      if (currentOption) {
        setSelected(currentOption.name);
      }
    }
  }, [currentSlug, options]);

  // Close dropdown when clicking outside
  useEffect(() => {
    const handleClickOutside = (event) => {
      if (dropdownRef.current && !dropdownRef.current.contains(event.target)) {
        setIsOpen(false);
      }
    };

    document.addEventListener('mousedown', handleClickOutside);
    return () => {
      document.removeEventListener('mousedown', handleClickOutside);
    };
  }, []);

  const handleSelect = (option) => {
    setSelected(option.name);
    setIsOpen(false);
    if (onSelect) onSelect(option);
  };

  const toggleDropdown = () => {
    setIsOpen(prev => !prev);
  };

  return (
    <div className="relative w-full max-w-xs" ref={dropdownRef}>
      {/* Dropdown Button */}
      <button
        type="button"
        onClick={toggleDropdown}
        className={`w-full flex items-center justify-between px-4 py-3 text-left rounded-lg border border-gray-200 shadow-sm hover:shadow-md transition-all ${
          !selected ? 'text-primaryGreen italic font-medium' : 'text-gray-800'
        }`}
        aria-haspopup="listbox"
        aria-expanded={isOpen}
      >
        <span className="truncate">
          {selected || (page === 'all-articles' ? placeholder : page)}
        </span>
        {isOpen ? (
          <FiChevronUp className="h-5 w-5 text-gray-500" />
        ) : (
          <FiChevronDown className="h-5 w-5 text-gray-500" />
        )}
      </button>

      {/* Dropdown Options */}
      <AnimatePresence>
        {isOpen && (
          <motion.ul
            initial={{ opacity: 0, y: -10 }}
            animate={{ opacity: 1, y: 0 }}
            exit={{ opacity: 0, y: -10 }}
            transition={{ duration: 0.2 }}
            className="absolute z-10 mt-1 w-full bg-white rounded-md shadow-lg overflow-hidden border border-gray-200"
            role="listbox"
          >
            {options.map((option) => (
              <motion.li
                key={option.slug}
                whileHover={{ backgroundColor: '#f5f5f5' }}
                transition={{ duration: 0.1 }}
                className="cursor-pointer"
              >
                <Link
                  href={`/blog/category/${option.slug}`}
                  passHref
                  legacyBehavior
                >
                  <a
                    className={`block px-4 py-3 text-sm ${
                      currentSlug === option.slug
                        ? 'bg-primaryGreen10 text-primaryGreen font-medium'
                        : 'text-gray-700 hover:bg-gray-50'
                    }`}
                    onClick={() => handleSelect(option)}
                    role="option"
                    aria-selected={currentSlug === option.slug}
                  >
                    {option.name}
                  </a>
                </Link>
              </motion.li>
            ))}
          </motion.ul>
        )}
      </AnimatePresence>
    </div>
  );
};

export default Dropdown;