'use client'
import { useRouter } from 'next/router';
import { useEffect, useState } from 'react';
import Navbar from './Navbar';
import Footer from './Footer2';
import Loading from '@/loading';

import { Poppins, Fraunces, Itim } from "next/font/google";

// Font configurations
const poppins = Poppins({
  subsets: ["latin"],
  weight: ["100", "200", "300", "400", "500", "600", "700", "800", "900"],
  style: ["normal", "italic"],
  variable: "--font-poppins",
  display: "swap",
});

const fraunces = Fraunces({
  subsets: ["latin"],
  weight: ["400", "500", "600", "700", "800", "900"],
  style: ["normal", "italic"],
  variable: "--font-fraunces",
  display: "swap", // Re-enabled as it's recommended for better performance
});

const itim = Itim({
  subsets: ["latin"],
  weight: ["400"],
  style: ["normal"],
  variable: "--font-itim",
  display: "swap",
});

// Loading state management hook
const usePageLoading = () => {
    const [loading, setLoading] = useState(false);
    const router = useRouter();
  
    useEffect(() => {
      const LOADING_DELAY = 2400; // Made the delay constant configurable
  
      const startLoading = () => setLoading(true);
      const stopLoading = () => {
        const timer = setTimeout(() => {
          setLoading(false);
        }, LOADING_DELAY);
        
        return () => clearTimeout(timer); // Cleanup timeout to prevent memory leaks
      };
  
      router.events.on('routeChangeStart', startLoading);
      router.events.on('routeChangeComplete', stopLoading);
      router.events.on('routeChangeError', stopLoading);
  
      return () => {
        router.events.off('routeChangeStart', startLoading);
        router.events.off('routeChangeComplete', stopLoading);
        router.events.off('routeChangeError', stopLoading);
      };
    }, [router]);
  
    return loading;
  };
  

// const usePageLoading = () => {
//   const [loading, setLoading] = useState(false);
//   const router = useRouter();

//   useEffect(() => {
//     let timer;

//     const startLoading = () => {
//       setLoading(true);
//       timer = setTimeout(() => setLoading(false), 2000); // Minimum loading time
//     };

//     const stopLoading = () => {
//       clearTimeout(timer);
//       setLoading(false);
//     };

//     router.events.on("routeChangeStart", startLoading);
//     router.events.on("routeChangeComplete", stopLoading);
//     router.events.on("routeChangeError", stopLoading);

//     return () => {
//       clearTimeout(timer);
//       router.events.off("routeChangeStart", startLoading);
//       router.events.off("routeChangeComplete", stopLoading);
//       router.events.off("routeChangeError", stopLoading);
//     };
//   }, [router]);

//   return loading;
// };



const ClientWrapper = ({ children }) => {
    const isLoading = usePageLoading();


      // Combine font variables
  const fontClasses = `${poppins.variable} ${fraunces.variable} ${itim.variable}`;

    // if (isLoading) {
    //     return <Loading />;
    //   }
  return (
    
    <div className={`${fontClasses} bg-[#FCFCFC] min-h-screen flex flex-col relative`}>
      <Navbar />
        {/* Loading screen overlay */}
        {isLoading && (
        <div className="fixed inset-0 bg-white flex items-center justify-center z-[2000]">
          <Loading />
        </div>
      )}
      <main className="flex-grow ">
      {/* {isLoading && <Loading />}  */}
      {!isLoading && <>{children}</> }
        {/* <>{children}</> */}
      </main>
      <Footer />
    </div>
  )
}

export default ClientWrapper