'use client'
import React, { useRef } from 'react';
import { useGSAP } from '@gsap/react';
import gsap from 'gsap';
import ScrollTrigger from "gsap/dist/ScrollTrigger";
// import { clientData } from '@/constants/data';


// Register GSAP plugins
gsap.registerPlugin(useGSAP);
gsap.registerPlugin(ScrollTrigger);

const ScrubComponent = () => {

  const containerRef = useRef(null);

  const clientData = [
    {
      id: 1,
      img: 'bg-client',
      header: 'Download the app & sign up as a client',
      description: 'Visit your preferred app store and download the HousehelpApp. Create your account by signing up as a client.'
    },
    {
      id: 2,
      img: 'bg-green-500',
      header: 'Post Your Task',
      description: 'Choose the relevant category for your task (e.g., Errands, House Chores, Other Services, Food Delivery). Fill in the required information, specify your offer price, and select your preferred payment method.'
    },
    {
      id: 3,
      img: 'bg-orange-500',
      header: 'Receive Offers, Negotiate and Communicate',
      description: 'Once your task is live, receive offers from helpers, negotiate prices, chat to discuss details, and choose based on experience, past jobs, and ratings.'
    },
    {
      id: 4,
      img: 'bg-blue-500',
      header: 'Job Completion',
      description: 'When the task is complete, make the payment using your chosen payment method. Rate your helper based on their performance.'
    }
  ];


  
  useGSAP(() => {
    // const ctx = gsap.context(() => {
   
      gsap.set(".photo:not(:first-child)", { opacity: 0, scale: 0.5 });
      
      const animation = gsap.to(".photo:not(:first-child)", {
        opacity: 1,
        scale: 1,
        duration: 0.6,
        stagger: 1
      });
      
      ScrollTrigger.create({
        trigger: ".gallery",
        start: "top 240px",
        end: "bottom 510px",
        pin: ".leftblock",
        animation: animation,
        scrub: true,
        markers: true,
      });
    // }, containerRef);
   
    
    // return () => ctx.revert();
  }, { dependencies: clientData,revertOnUpdate: true });


  

  return (
    <div ref={containerRef} className="w-full h-full bg-purple-300 hidden lg:inline-block">
      <div className="w-full max-w-6xl mx-auto flex flex-col md:flex-row items-stretch gallery mb-[180px]">
        {/* Left Block - Photos */}
        <div className="w-full md:w-1/2 leftblock h-[410px] relative overflow-hidden">
          {clientData.map((item) => (
            <div
              key={item.id}
              className={`photo absolute top-0 left-0 w-full max-w-[468px] h-[420px] rounded ${item.img} bg-cover`}
            />
          ))}
        </div>

        {/* Right Block - Content */}
        <div className="w-full md:w-1/2">
          {clientData.map((item) => (
            <div key={item.id} className="flex flex-col justify-center max-h-[400px] pt-[120px] p-6">
              <div className="border border-gray-200 rounded-lg p-6 shadow-md">
                <div className="flex items-start gap-4">
                  <div className="flex-shrink-0 w-12 h-12 bg-[#55a654] text-white rounded-lg flex items-center justify-center text-xl font-bold">
                    {item.id}
                  </div>
                  <div className="flex-1">
                    <h5 className="text-xl font-bold mb-2">{item.header}</h5>
                    <p className="text-gray-600">{item.description}</p>
                  </div>
                </div>
              </div>
            </div>
          ))}
        </div>
      </div>
    </div>
  );
};

export default ScrubComponent;
