import React from 'react'
import * as motion from "framer-motion/client"
import Card from '../Card'

const JobSection = () => {
    const variants = {
        hidden: {opacity: 0, x:0, y:20},
        enter: { opacity: 1, x: 0, y: 0,  transition: {
          type: "spring",
          bounce: 0.1,
          duration: 1
        } },
      }
      // #f9fffa
      // #e6ff6a
  return (
    <motion.div initial="hidden" whileInView="enter"  viewport={{ once: true, amount: .3 }} className="w-full h-full flex justify-center pt-[120px] overflow-hidden bg-[#D2E0FB] rounded-t-[.5rem] ">
      <div className="w-full max-w-[1248px] h-full text-black px-4 lg:px-8 ">
        <motion.h3 variants={variants} className="font-bold font-fraunces text-[32px] md:text-[40px] xl:text-[48px] w-full max-w-[300px] sm:max-w-[450px] ">What do you need <span className="text-[#55a654]">help</span> with today ?</motion.h3>
     <Card />
      </div>
    </motion.div>
  )
}

export default JobSection