import React, { useState } from 'react';
import Image from 'next/image';
import female from '@/public/hha-female-search.png';
import * as motion from "framer-motion/client";

const Hero = () => {
  const [isImageLoaded, setIsImageLoaded] = useState(false); // State to track image loading

  const handleImageLoad = () => {
    setIsImageLoaded(true); // Set image loaded state to true
  };

  const variants = {
    hidden: { opacity: 0, x: 0, y: 60 },
    enter: {
      opacity: 1, x: 0, y: 0,
      transition: {
        type: "spring",
        bounce: 0.1,
        duration: 1
      }
    },
  };

  const variantsImg = {
    hidden: { opacity: 0, x: 60, y: 0 },
    enter: {
      opacity: 1, x: 0, y: 0,
      transition: {
        type: "spring",
        bounce: 0.2,
        duration: 1,
        delay: 0.25
      }
    },
  };

  return (
    <motion.div
      initial="hidden"
      whileInView="enter"
      viewport={{ once: true, amount: 0.6 }}
      className='w-full h-fit flexCenter pt-[124px] md:pt-[148px] pb-[48px] md:pb-[72px] xl:pb-[148px] bg-[#edf2ff] overflow-hidden px-4 md:px-8'
    >
      <div className='w-full max-container-1248 flexBetween flex-col md:flex-row'>
        <div className='pt-0'>
          <motion.div variants={variants} className="div">
            <h2 className='prodigySans700 items-center text-[28px] md:text-[36px] max-w-[360px] md:max-w-[548px] text-[#1c1c1c]'>
              Select from <span className='font-bold text-primaryGreen'>top-rated, vetted helpers</span> to complete your tasks with efficiency and ease.
            </h2>
            <h3 className='font-normal text-[18px] md:text-[20px] xl:text-[22px] max-w-[500px] pt-[26px]'>
              Don’t sweat it—delegate it! Plus, get 5% cashback on every task you complete through us.
            </h3>
          </motion.div>
        </div>

        {/* Image Container with Spinner */}
        <motion.div variants={variantsImg} className='pt-12 lg:pt-0 relative'>
          {!isImageLoaded && (
            <div className="absolute inset-0 flexCenter">
              {/* Spinner */}
              <div className="animate-spin rounded-full h-8 w-8 border-b-2 border-gray-900"></div>
            </div>
          )}
          <Image
            src={female}
            priority
            alt=''
            className='w-full max-w-[246px] md:max-w-[364px]'
            onLoad={handleImageLoad}
          />
        </motion.div>
      </div>
    </motion.div>
  );
};

export default Hero;