import React from 'react'
import * as motion from "framer-motion/client";
import Image from "next/image";
import manSmilingPhone from '@/public/man-smiling-phone.png'
import walletCard from '@/public/wallet-card.png'

const CashRewards = () => {
    const variantHeader = {
        hidden: { opacity: 0, x: 0, y: 30 },
        enter: {
          opacity: 1, x: 0, y: 0, transition: {
            type: "spring",
            bounce: 0.2,
            duration: 0.6
          }
        },
      };
    
      const variants = {
        hidden: { opacity: 0, x: -50, y: 0 },
        enter: {
          opacity: 1, x: 0, y: 0,
          transition: {
            type: "spring",
            bounce: 0.2,
            duration: 1.1
          }
        },
      };
      const transitionValues = {
        duration: 3,
        repeat: Infinity,
        repeatType: 'reverse',
        ease: "easeOut"
      };
  return (
    <motion.div
    initial="hidden"
    whileInView="enter"
    viewport={{ once: true, amount: 0.3 }}
    className="w-full flex flex-col justify-center items-center py-[48px] md:py-[72px] px-4 sm:px-8 xl:px-16 bg-[#fdfdff]"
  >
     <div className="w-full font-poppins flexCenter flex-col sm:flex-row gap-4 md:gap-8 xl:gap-12">
        <motion.div
          className="w-fit flex-col gap-4 mt-[16px] md:mt-[32px] xl:mt-0"
        >
          <motion.h4 variants={variants} className="w-full max-w-[340px] text-[28px] md:text-[36px] prodigySans600 leading-tight ">
          Earn 5% Cashback & Referral Rewards
          </motion.h4>
          <motion.p variants={variants} className="w-full max-w-[480px] text-[14px] md:text-[16px] prodigySans400 tracking-wide mt-4 ">
          Complete tasks or refer friends on HouseHelpApp to earn cashback and referral rewards. Use your rewards to buy airtime and data directly in the app.
          </motion.p>
          <Image
            src={walletCard}
            alt="wallet card"
            className="w-full max-w-[280px] mt-[48px] md:mt-[56px]"
          />
        </motion.div>

        <motion.div
          transition={{
            y: transitionValues
          }}
          animate={{
            y: [0, -8, 0],
          }}
        >
          <Image
            src={manSmilingPhone}
            alt="man holding phone"
            className="w-full max-w-[506px] mt-[48px] md:mt-[56px]"
          />
        </motion.div>
      </div>
  </motion.div>
  )
}

export default CashRewards

// bg-[#eef4ff]
// bg-[#f8faff]