import React from "react";
import { FaBriefcase, FaLocationArrow } from "react-icons/fa";
import { fakedata } from "@/constants/data";
import Marquee from "react-fast-marquee";
import Image from "next/image";

const Card = (props) => {
  return (
    <div className="w-full inline-block pt-[3rem] pb-[8rem] ">
      <div className="overflow-hidden z-10 mx-auto w-full max-w-[1800px]">
          <Marquee play loop={0} speed={50} gradient={false} pauseOnHover={true}>
            {fakedata.map((items, id) =>
              id < 6 ? (
                <div
                  className=" w-[12rem] md:w-[16rem] xl:w-[20rem] h-[8.5rem] market-box border-[1px] rounded-lg p-3 shadow-sm border-[#8AB88A] mx-2 md:mx-4 bg-[#fbfffb] "
                  key={id}
                >
                  <div className="flex items-center">
                    <div className="pr-1 xl:pr-2 ">
                      <Image
                        src={items.imgUrl}
                        alt=""
                        className="w-[2em] h-[2em] rounded-full bg-slate-500"
                      />
                     
                    </div>
                    <div className="flexBetween w-full flex-wrap ">
                    <span>
                        <p className=" text-[16px] font-bold ">{items.name}</p>{" "}
                      </span>
                    <p className="text-[15px] font-extrabold"> {items.price} </p>
                    </div>

                  </div>

                  <div className="mt-[8px] md:mt-[18px]">
                    <div className="flex flex-row">
                      <FaBriefcase className="mx-[.5em]" /> 
                     <p className="w-full max-w-[271px] text-[13px] font-[400] ">{items.task.substring(0, 44)}</p> 
                    </div>
                    <div className="flex mt-[8px] ">
                      <FaLocationArrow className="mx-[.5em] " /> 
                      <p className="w-full max-w-[271px] text-[12px] font-[400] ">{items.location}</p>
                    </div>
                  </div>
                </div>
              ) : null
            )}
          </Marquee>
    

          <Marquee play loop={0} speed={50} direction="right" gradient={false} pauseOnHover={true}>
            {fakedata.map((items, id) =>
              id > 5 ? (
                <div
                  className=" mt-[2rem]  w-[12rem] md:w-[16rem] xl:w-[20rem] h-[8.5rem] border-[1px] rounded-lg p-3 shadow-sm border-[#8AB88A] mx-2 md:mx-4 bg-[#fbfffb] market-box  "
                  key={id}
                >
                   <div className="flex items-center">
                   <div className="pr-1 xl:pr-2">

                      <Image
                        src={items.imgUrl}
                        alt=""
                        className="w-[2em] h-[2em] rounded-full bg-slate-500"
                      />
                   </div>
                     
                  
                    <div className="flexBetween w-full flex-wrap">
                    <span>
                        <p className=" text-[16px] font-bold ">{items.name}</p>{" "}
                      </span>
                    <p className="text-[15px] font-extrabold"> {items.price} </p>
                    </div>

                  </div>

                  <div className="mt-[8px] md:mt-[18px]">
                    <div className="flex flex-row">
                      <FaBriefcase className="mx-[.5em]" /> 
                     <p className="w-full max-w-[271px] text-[13px] font-[400] ">{items.task.substring(0, 43)}</p> 
                    </div>
                    <div className="flex mt-[8px] ">
                      <FaLocationArrow className="mx-[.5em] " /> 
                      <p className="w-full max-w-[271px] text-[13px] font-[400] ">{items.location}</p>
                    </div>
                  </div>
                </div>
              ) : null
            )}
          </Marquee>
      </div>
    </div>
  );
};

export default Card;

// py-[8rem]
// border-[#8AB88A]