// 'use client'
// import React, { useEffect, useState } from 'react';
// import BlogCardContainer from './BlogCardContainer';
// import { getCategories } from '@/services/prod';
// import Dropdown from '../DropdownBlog';
// import Link from 'next/link';

// const BlogPage = ({ posts, setSelected, setActive, data }) => {

//   const [categories, setCategories] = useState([]);

//   useEffect(() => {
//     getCategories().then((newCategories) => {
//       setCategories(newCategories)
     
//     })
//   }, [])

//   const handleSelection = (option) => {
//     console.log("Selected option:", option);
//   };

// let page = 'all-articles'
//   return (
//       <div className='pt-28 sm:pt-36 pb-32'>
//         <div className='pb-8 flex flex-col md:flex-row justify-between items-center h-fit' >   
//             <h1 className=' text-[26px] md:text-[30px] lg:text-[36px] text-[#404040] tracking-wide md:tracking-wide font-fraunces font-bold  max-w-[400px] lg:max-w-[550px] mb-[2rem] md:mb-[3rem] '>
//               Get the best Tips and DIYs for your everyday needs
//             </h1>

// <div>
//          <Dropdown options={categories}  onSelect={handleSelection} page={page} />
// </div>

//         </div>


//         <BlogCardContainer posts={posts} setSelected={setSelected} setActive={setActive} />
//       </div>

//   )
// }

// export default BlogPage


'use client'
import React, { useEffect, useState } from 'react';
import BlogCardContainer from './BlogCardContainer';
import { getCategories } from '@/services/prod';
import Dropdown from '../DropdownBlog';
import { motion } from 'framer-motion';

const BlogPage = ({ posts }) => {
  const [categories, setCategories] = useState([]);

  useEffect(() => {
    getCategories().then(setCategories);
  }, []);

  const handleSelection = (option) => {
    console.log("Selected option:", option);
  };

  return (
    <div className='pt-28 sm:pt-36 pb-32 px-4 max-w-7xl mx-auto'>
      <div className='pb-8 flex flex-col md:flex-row justify-between items-start gap-8'>
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.5 }}
        >
          <h1 className='text-3xl md:text-4xl lg:text-5xl text-gray-800 font-bold max-w-2xl font-fraunces leading-tight'>
            Get the best <span className='text-primaryGreen'>Tips and DIYs</span> for your everyday needs
          </h1>
          <p className='mt-4 text-gray-600 max-w-xl'>
            Discover expert advice and practical solutions to simplify your daily life.
          </p>
        </motion.div>

        <motion.div
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.5, delay: 0.2 }}
          className='w-full md:w-auto'
        >
          <Dropdown 
            options={categories}  
            onSelect={handleSelection} 
            page='all-articles' 
          />
        </motion.div>
      </div>

      <BlogCardContainer posts={posts} />
    </div>
  );
};

export default BlogPage;