

// 'use client'
// /* eslint-disable @next/next/no-img-element */

// import React, { useState, useEffect } from 'react';
// import BlogCardComponent from '../BlogCardComponent';


// const BlogCardContainer = ({ posts, setSelected, setActive }) => {


//   const [no_Of_Element, setNo_Of_Element] = useState(8);

//   // useEffect(() => {
//   //   // 👇️ scroll to top on page load
//   //   // setSelected(data)
//   //   setActive(true)
//   //   window.scrollTo({top: 0, left: 0, behavior: 'smooth'});
//   // }, []);

//   const loadMore = function () {
//     // setNoOfElement(noOfElement + noOfElement);
//     setNo_Of_Element(no_Of_Element + no_Of_Element);
//   };


//   return (
//     <div>

//       <BlogCardComponent posts={posts} no_Of_Element={no_Of_Element} pageDisplay={'BlogPage'} />

//       <div className="flex items-center justify-center mt-[6rem]">
//         <button
//           className="w-[6.5rem] h-[3rem] cursor-pointer  text-white bg-[#55a654] flex justify-center items-center font-medium rounded-md  mb-[1rem] hover:text-white hover:bg-[#4f9b4e] hover:translate-y-1 transition-all ease-linear"
//           onClick={() => loadMore()}
//         >
//           {" "}
//           Load More
//         </button>
//       </div>
//     </div>


//   )
// }

// export default BlogCardContainer



'use client'
import React, { useState } from 'react';
import BlogCardComponent from '../BlogCardComponent';
import { motion } from 'framer-motion';

const BlogCardContainer = ({ posts }) => {
  const [noOfElements, setNoOfElements] = useState(8);
  const [isLoading, setIsLoading] = useState(false);

  const loadMore = () => {
    setIsLoading(true);
    setTimeout(() => {
      setNoOfElements(prev => prev + 4);
      setIsLoading(false);
    }, 500);
  };

  const hasMorePosts = noOfElements < posts.length;

  return (
    <div className='space-y-12'>
      <BlogCardComponent 
        posts={posts} 
        no_Of_Element={noOfElements} 
        pageDisplay={'BlogPage'} 
      />

      {hasMorePosts && (
        <motion.div 
          initial={{ opacity: 0 }}
          animate={{ opacity: 1 }}
          className="flex justify-center mt-16"
        >
          <button
            onClick={loadMore}
            disabled={isLoading}
            className="px-8 py-3 bg-primaryGreen text-white font-medium rounded-lg hover:bg-green-600 transition-all duration-300 flex items-center gap-2"
          >
            {isLoading ? (
              <>
                <svg className="animate-spin h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                  <circle className="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" strokeWidth="4"></circle>
                  <path className="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                </svg>
                Loading...
              </>
            ) : (
              <>
                Load More
                <svg xmlns="http://www.w3.org/2000/svg" className="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                  <path fillRule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-11a1 1 0 10-2 0v3.586L7.707 9.293a1 1 0 00-1.414 1.414l3 3a1 1 0 001.414 0l3-3a1 1 0 00-1.414-1.414L11 10.586V7z" clipRule="evenodd" />
                </svg>
              </>
            )}
          </button>
        </motion.div>
      )}
    </div>
  );
};

export default BlogCardContainer;