import React from 'react';
import Link from 'next/link';
import Image from 'next/image';
import moment from 'moment';
import {grpahCMSImageLoader} from '../util';

const BlogCardComponent = ({ posts, no_Of_Element, pageDisplay }) => {
    return (
        <div>
            <div className='flex flex-wrap my-0 mx-[1rem] max-w-[1200px] sm:m-0 sm:p-0 gap-4 justify-center hover:cursor-pointer'>
                {posts?.slice(0, no_Of_Element).map((data, index) => (
                    <div
                    className="max-w-[288px] max-h-[390px] bg-[#fbfbfb] rounded-md shadow-md text-black overflow-hidden"
                    key={index}
                    
                    >
                        <Link href={`/blog/${data?.slug}`}  target="_blank" rel="noopener noreferrer">
                            <Image
                            priority
                            //  unoptimized
                                className="w-full h-[9rem] inherit rounded-t-md object-cover hover:scale-[1.075] transition-all ease-linear duration-[1.75]"
                                // loader={grpahCMSImageLoader}
                                src={data?.featuredImage?.url}
                                alt="blog-post image"
                                width={100}
                                height={100}

                            />
                            <div className="py-[1rem] px-[.5rem]  ">
                                <p className="text-[14px] prodigySans500">{data?.author?.name}</p>
                                <p className="text-[12px] prodigySans500 text-primaryGreen">
                                    {moment(data?.datePublished).format("MMM DD, YYYY")}
                                </p>
                                <h1 className="text-[14px] prodigySans600 text-[#1c1c1c] mt-2 hover:text-primaryGreen transition-all ease-linear">
                                    {data?.title}
                                </h1>
                                <p className={`${pageDisplay !== 'BlogPage' ? 'hidden' : 'inline-block'} text-[12px] font-normal mt-[4px]`}>{`${ data?.excerpt?.substring(0, 110)}...`}</p>
                            </div>
                        </Link>
                    </div>
                ))}
            </div>
        </div>
    )
}

export default BlogCardComponent