'use client'
import React, { useState } from 'react';
import { accord } from '@/constants/data';
import { FaAngleDown, FaAngleUp } from 'react-icons/fa';

const Accordion = () => {
    const [selected, setSelected] = useState(null);

    const toggle = (i) => {
        setSelected(selected === i ? null : i);
    };

    return (
        <div className='px-4'>
            <div className='w-full max-w-[55em] mx-auto'>
                {accord.map((item, i) => (
                    <div className='mb-[3em] bg-[#fbfbfb] shadow-sm' key={i}>
                        <div
                            className='flex justify-between items-center text-[1em] font-[500] cursor-pointer px-[.75em] py-[1.25em] outline outline-1 outline-[#e1e1e1] rounded-t-sm relative'
                            onClick={() => toggle(i)}
                        >
                            <h3 className='text-[18px] md:text-[20px] font-semibold font-fraunces'>
                                {item.question}
                            </h3>
                            {selected === i ? <FaAngleUp /> : <FaAngleDown />}
                        </div>
                        <div
                            className={`${
                                selected === i
                                    ? 'h-auto max-h-max py-[1.5em] px-[1em] animate-slide-down outline outline-1 outline-[#dadada]'
                                    : 'max-h-0 overflow-hidden animate-slide-up'
                            }`}
                        >
                            {item.answer}
                        </div>
                    </div>
                ))}
            </div>
        </div>
    );
};

export default Accordion;
